% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-.R
\name{layer-like}
\alias{layer-like}
\alias{layer}
\alias{is_layer_like}
\alias{as_layer_like}
\alias{as_layer_like.default}
\alias{as_layer_like.LayerInstance}
\alias{as_layer_like.list}
\alias{as_layer_like.layer_list}
\title{ggplot2 layer-like objects}
\usage{
is_layer_like(x)

as_layer_like(x)

\method{as_layer_like}{default}(x)

\method{as_layer_like}{LayerInstance}(x)

\method{as_layer_like}{list}(x)

\method{as_layer_like}{layer_list}(x)
}
\arguments{
\item{x}{A \link{layer-like} object. See \emph{Details}.}
}
\value{
For \code{is_layer_like()}, a \code{logical}: \code{TRUE} if \code{x} is layer-like, \code{FALSE} otherwise.

For \code{as_layer_like()}, a \code{"LayerInstance"} or a \code{\link[=layer_list]{layer_list()}}.
}
\description{
For technical reasons related to how \pkg{ggplot2} implements layers, there
is no single class from which all valid \pkg{ggplot2} layers and lists of
layers inherit. Thus, \pkg{ggblend} \link{operation}s supports a variety of "layer-like"
objects, documented here (see \emph{Details}).
}
\details{
\pkg{ggblend} \link{operation}s can be applied to several \code{\link[ggplot2:layer]{ggplot2::layer()}}-like objects,
including:
\itemize{
\item objects of class \code{"LayerInstance"}; e.g. \code{stat}s and \code{geom}s.
\item \code{\link[=list]{list()}}s of layer-like objects.
\item \code{\link[=layer_list]{layer_list()}}s, which are a more type-safe version of \code{\link[=list]{list()}}s of
layer-like objects.
}

Anywhere in \pkg{ggblend} where a function parameter is documented as being
\link{layer-like}, it can be any of the above object types.
}
\section{Functions}{
\itemize{
\item \code{is_layer_like()}: checks if an object is layer-like according to \pkg{ggblend}.

\item \code{as_layer_like()}: validates that an object is layer-like and converts
it to a \code{"LayerInstance"} or \code{\link[=layer_list]{layer_list()}}.

}}
\examples{
library(ggplot2)

is_layer_like(geom_line())
is_layer_like(list(geom_line()))
is_layer_like(list(geom_line(), scale_x_continuous()))
is_layer_like(list(geom_line(), "abc"))
}
