% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_corset_elongated.R
\name{gg_corset_elongated}
\alias{gg_corset_elongated}
\title{CORSET PLOT}
\usage{
gg_corset_elongated(
  data,
  x_var,
  x_vals,
  y_var,
  group,
  c_var,
  vio_fill = NA,
  line_size = NA
)
}
\arguments{
\item{data}{The name of the data frame.}

\item{x_var}{The name of the x_axis variable.}

\item{x_vals}{The values of the two time points.}

\item{y_var}{The repeated measure variable name.}

\item{group}{The name of units measured at each time point such as 'ID'.}

\item{c_var}{The name of variable to visualize by line colour, such as percent change.}

\item{vio_fill}{Optional (defaults to a soft black). Use to change the fill colour of the half violins.}

\item{line_size}{Optional. Use to change the size (thickness) of the lines which visualize the c_var.}
}
\value{
ggplot2 graphical object
}
\description{
This function visualizes a corset plot in long format.
}
\examples{

long.df <- data.frame(time = c("pre","post","pre","post","pre","post"),
             days  = c(3,5,4,0,7,7),
             change = c(28.57,28.57,-57.14,-57.14,0,0),
             id = c(1,1,2,2,3,3))
gg_corset_elongated(data = long.df, x_var = "time",
                   x_vals = c("pre","post"), y_var = "days",
                   group = "id", c_var = "change")

}
