% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_spread.R
\name{position_spread}
\alias{position_spread}
\title{Spread Overlapping Grobs Spread overlapping groups by shrinking them to fit
within the data's \code{y} range.}
\usage{
position_spread(height = NULL, reverse = FALSE, padding = 0.2)
}
\arguments{
\item{height}{One of \code{total} (default), \code{panel}, \code{single}, a numeric scalar
value to give all geoms equal space, or a numeric vector the length of
\code{panels*groups} for manually specifying the height of each group.}

\item{reverse}{Reverse the order of segments within overlapping \code{y} ranges.}

\item{padding}{Multiple of height. Will shrink/enlarge groups to fit within a
region.}
}
\description{
Spread Overlapping Grobs Spread overlapping groups by shrinking them to fit
within the data's \code{y} range.
}
\examples{
library(ggplot2)

x <- data.frame(y = rnorm(1000), x="", myGroup=sample(1:3, 1000, TRUE))

ggplot(x, aes(x, y))+
geom_point(aes(group=myGroup), position=position_spread(height = 0.5))
}
