% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmc_utils.R
\name{density.dmc}
\alias{density.dmc}
\title{Calculate Probability Density for an Experimental Condition}
\usage{
\method{density}{dmc}(x, C = NA, ...)
}
\arguments{
\item{x}{a data.cell as a data frame as welle dmc class, containing
only one experimental condition.}

\item{C}{a string, e.g., "r1" or a logical vector to represent the
correctness column in a data frame}

\item{...}{other arguments}
}
\description{
A S3 method derived from \pkg{stats} density to get probability density
for a specified experimental condition. The user has to indicate
a correctness column.
}
\examples{
model <- model.dmc(
 p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1", t0="1",st0="1"),
 constants = c(st0=0,d=0),
 match.map = list(M=list(s1="r1",s2="r2")),
 factors   = list(S=c("s1","s2")),
 responses = c("r1","r2"),
 type      = "rd")

pVec <- c(a=1,v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)
dat1 <- simulate(model, nsim=1e2, p.vector=pVec)
mdi1 <- data.model.dmc(dat1, model)
censored.s1  <- censor(mdi1[mdi1$S=="s1", ], xlim=c(.2, 3))
s1r1.density <- density(censored.s1, C="r1")
head(s1r1.density)
## Source: local data frame [1,024 x 3]
##             x           y     C
##         (dbl)       (dbl) (lgl)
## 1  0.02077313 0.004432689  TRUE
## 2  0.02276278 0.004923698  TRUE
## 3  0.02475243 0.005480113  TRUE
## 4  0.02674208 0.006079448  TRUE
## 5  0.02873173 0.006731685  TRUE
## 6  0.03072138 0.007471079  TRUE
## 7  0.03271103 0.008265728  TRUE
## 8  0.03470068 0.009124208  TRUE
## 9  0.03669033 0.010097473  TRUE
## 10 0.03867998 0.011141091  TRUE
## ..        ...         ...   ...
}
\keyword{density.dmc}

