% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labs.R
\name{easy_rotate_labels}
\alias{easy_rotate_labels}
\alias{easy_rotate_x_labels}
\alias{easy_rotate_y_labels}
\title{Easily rotate \code{x} axis labels}
\usage{
easy_rotate_labels(which = c("both", "x", "y"), angle = 90,
  side = c("left", "middle", "right"), teach = FALSE)

easy_rotate_x_labels(angle = 90, side = c("left", "middle", "right"),
  teach = FALSE)

easy_rotate_y_labels(angle = 90, side = c("left", "middle", "right"),
  teach = FALSE)
}
\arguments{
\item{which}{which axis or axes to rotate, by default "both"}

\item{angle}{angle through which the text should be rotated. Can also be one
of "startattop" or "startatbottom" to define where the text should start.}

\item{side}{horizontal justification of the text before rotation}

\item{teach}{print longer equivalent \code{\link[ggplot2]{ggplot2}}
expression?}
}
\value{
a \code{\link[ggplot2]{theme}} object which can be used in
\code{\link[ggplot2]{ggplot2}} calls.
}
\description{
A shortcut to
}
\details{
theme(axis.text.x = element_text(angle, hjust))
}
\examples{
library(ggplot2)
ggplot(mtcars, aes(mpg, hp)) +
  geom_point() +
  easy_rotate_labels()
}
