% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgg.R
\name{rgg}
\alias{rgg}
\title{Remove and replace ggplot2 layers.}
\usage{
rgg(p, oldGeom, oldGeomIdx = 1, newLayer = NULL)
}
\arguments{
\item{p}{ggplot2 plot object}

\item{oldGeom}{character string of the name of the layer to remove}

\item{oldGeomIdx}{numeric of which index of OldGeom to remove (default is 1)}

\item{newLayer}{ggplot layer or list of layers}
}
\description{
Removes specified layers from a ggplot object and gives 
the option to replace them with a new layer. This layer can be either 
a geom object created from regular ggplot functions or an output from 
the ggedit gadget. 
In the latter case the layers are found in the updatedLayers object in 
the ggedit output.
}
\examples{
p=ggplot(iris,aes(x =Sepal.Length,y=Sepal.Width))
p=p+geom_point(aes(colour=Species))+geom_line()
p
p\%>\%rgg('point',1)
\donttest{
x=ggedit(p)
pnew=p\%>\%rgg('point',1,x$updatedLayers[[1]])
pnew
}
}
