% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_predictions.R
\name{pool_predictions}
\alias{pool_predictions}
\title{Pool Predictions or Estimated Marginal Means}
\usage{
pool_predictions(x, ...)
}
\arguments{
\item{x}{A list of \code{ggeffects} objects, as returned by \code{\link[=ggpredict]{ggpredict()}},
\code{ggemmeans()} or \code{ggeffect()}.}

\item{...}{Currently not used.}
}
\value{
A data frame with pooled predictions.
}
\description{
This function "pools" (i.e. combines) multiple \code{ggeffects} objects, in
a similar fashion as \code{\link[mice:pool]{mice::pool()}}.
}
\details{
Averaging of parameters follows Rubin's rules (\emph{Rubin, 1987, p. 76}).
}
\examples{
# example for multiple imputed datasets
if (require("mice")) {
  data("nhanes2")
  imp <- mice(nhanes2, printFlag = FALSE)
  predictions <- lapply(1:5, function(i) {
    m <- lm(bmi ~ age + hyp + chl, data = complete(imp, action = i))
    ggpredict(m, "age")
  })
  pool_predictions(predictions)
}
}
\references{
Rubin, D.B. (1987). Multiple Imputation for Nonresponse in Surveys. New York:
John Wiley and Sons.
}
