% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggspectro.R
\name{ggspectro}
\alias{ggspectro}
\title{Prepare a ggplot object to represent spectrogram data}
\usage{
ggspectro(data, mapping = aes(), summary_FUN = mean,
  summary_time_window = mins(30), time_wrap = NULL, time_offset = 0,
  ...)
}
\arguments{
\item{data}{\link[behavr:behavr]{behavr::behavr} table containing the data and metadata}

\item{mapping}{default list of aesthetic mappings to use for plot}

\item{summary_FUN}{method (function) used to summarise \code{variable} over time (typically, the mean)}

\item{summary_time_window}{width (in seconds) of the time window to compute a summary on}

\item{time_wrap}{time (in seconds) used to wrap the data (see details)}

\item{time_offset}{time offset (i.e. phase, in seconds) when using \code{time_wrap}}

\item{...}{additional arguments to be passed to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}}
}
\description{
This function summarises spectrogram data (containing spectrograms of multiple individual),
to show period on the \code{y} axis, time on the \code{x} axis and power on the \code{z} axis (\emph{e.g.} as a colour).
}
\examples{
\donttest{
library(zeitgebr)
data(dams_sample)
dt <- dams_sample
spect_dt <- spectrogram(activity, dt)
pl <- ggspectro(spect_dt,time_wrap = hours(24)) + stat_tile_etho() + scale_y_hours(log=T) +
  stat_ld_annotations(ld_colours = c("grey","black"))
pl + facet_grid(period_group ~ .)
pl + facet_wrap(~ id)
}
}
\references{
\itemize{
\item The relevant \href{https://rethomics.github.io/ggetho.html#spectrogram}{rethomic tutorial section}
}
}
\seealso{
\itemize{
\item \link{ggperio} to visualise periodograms
}
}
