% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_fan.R
\name{geom_fan}
\alias{geom_fan}
\title{Fan plot visualising intervals of a distribution}
\usage{
geom_fan(mapping = NULL, data = NULL, stat = "interval",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  intervals = (2:98)/100, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{stat}{Use to override the default use of \code{\link{stat_interval}}}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{intervals}{specify the collection of intervals to be represented in the
fan.}

\item{...}{other arguments passed on to \code{layer}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Fan Plots allow the distribution of a variable to be visualised by
representing sets of central probability intervals through colour.
For every value of \code{x}, \code{geom_fan} computes quantiles of \code{y} and uses these to plot
intervals containing increasing proportions of the total density of \code{y}.
Intervals are mapped to a continuous colour scale, so that changes in colour
represent intervals covering an increasing proportion of total density.
Quantiles can also be precomputed and mapped to the aesthetic \code{quantile}.
This function is designed with the need to summarise MCMC posterior
distributions in mind, and implements the functionality of the \code{fanplot}
package in \code{ggplot2}. Note that there should be enough observations of 
\code{y} at each \code{x} to allow estimation of the specified quantiles.
}
\section{Aesthetics}{


\code{geom_fan} understands the following aesthetics (required aesthetics are in bold):

\itemize{
\item \strong{x}
\item \strong{y}
\item \code{alpha}
\item \code{group}
\item \code{quantile}
}
}

\examples{

# Basic use. The data frame must have multiple y values for each
# x
library(ggplot2)

ggplot(fake_df, aes(x=x,y=y)) +geom_fan()


# use precomputed quantiles - reducing storage requirements.
intervals = 1:19/20
fake_q <- calc_quantiles(fake_df, intervals=intervals)
# intervals in geom_fan must be the same as used to compute quantiles.
ggplot(fake_q, aes(x=x,y=y, quantile=quantile)) +
 geom_fan(intervals=intervals)


# change the colour scale
ggplot(fake_df, aes(x=x,y=y)) + geom_fan() + scale_fill_gradient(low="red", high="pink")


}
\seealso{
\code{stat_summary} Summarises y at each value of x

\code{stat_quantile} Uses quantile regression to predict quantiles

\code{geom_interval} Plot intervals boundaries as lines
}
