% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_area}
\alias{gf_area}
\title{Formula interface to geom_area()}
\usage{
gf_area(object = NULL, gformula = NULL, data = NULL, alpha, color, fill,
  group, linetype, size, xlab, ylab, title, subtitle, caption, geom = "area",
  stat = "identity", position = "identity", show.legend = NA,
  show.help = NULL, inherit = TRUE, environment = parent.frame(), ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{fill}{A color for filling, or a formula used for mapping fill.}

\item{group}{Used for grouping.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{size}{A numeric size or a formula used for mapping size.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}
}
\description{
For each x value, \code{geom_ribbon} displays a y interval defined
by \code{ymin} and \code{ymax}. \code{geom_area} is a special case of
\code{geom_ribbon}, where the \code{ymin} is fixed to 0.
}
\examples{
if (require(dplyr) && require(mosaicData)) {
  Temps <- Weather \%>\%
    filter(city == "Chicago", year == 2016, month <= 4)
  gf_linerange(low_temp + high_temp  ~ date, color = ~ high_temp, data = Temps)
  gf_ribbon(low_temp + high_temp ~ date, data = Temps, color = "navy", alpha = 0.3)
  gf_area(high_temp ~ date, data = Temps, color = "navy", alpha = 0.3)

  gf_ribbon(low_temp + high_temp ~ date, data = Weather, alpha = 0.3) \%>\%
    gf_facet_grid(city ~ .)

  gf_linerange(low_temp + high_temp ~ date, color = ~ high_temp, data = Weather) \%>\%
    gf_facet_grid(city ~ .) \%>\%
    gf_refine(scale_colour_gradientn(colors = rev(rainbow(5))))
}

}
\seealso{
\code{\link[ggplot2:geom_area]{ggplot2::geom_area()}}
}
