% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_aux.R
\name{gf_labs}
\alias{gf_labs}
\alias{gf_lims}
\alias{gf_refine}
\title{Non-layer functions for gf plots}
\usage{
gf_labs(object, ...)

gf_lims(object, ...)

gf_refine(object, ...)
}
\arguments{
\item{object}{a gg object}

\item{...}{additional arguments passed through to the similarly named function in
\pkg{ggplot2}.}
}
\value{
a modified gg object
}
\description{
These functions modify things like labels, limits, scales, etc. for plots
ggplot2 plots. They are wrappers around functions in ggplot2 that allow for
chaining syntax.
}
\details{
\code{gf_refine()} provides a mechanism to replace \code{+} with the
chaining operator from \pkg{magrittr}.
Each of its \code{\dots} arguments is added in turn to the
base plot in \code{object}.  The other functions are thin wrappers around
specific \code{ggplot2} refinement functions and pass their \code{\dots}
arguments through to the similarly named \code{ggplot2} functions.
}
\examples{
gf_dens(~cesd, color = ~substance, size = 1.5, data = mosaicData::HELPrct) \%>\%
  gf_labs(
    title = "Center for Epidemiologic Studies Depression measure",
    subtitle = "(at baseline)",
    color = "Abused substance: ",
    x = "CESD score",
    y = "",
    caption = "Source: HELPrct"
  ) \%>\%
  gf_theme(theme_classic()) \%>\%
  gf_theme(
    axis.text.y = element_blank(),
    legend.position = "top",
    plot.title = element_text(hjust = 0.5, color = "navy"),
    plot.subtitle = element_text(hjust = 0.5, color = "navy", size = 12)
  )

gf_point(eruptions ~ waiting, data = faithful, alpha = 0.5)
gf_point(eruptions ~ waiting, data = faithful, alpha = 0.5) \%>\%
  gf_lims(x = c(65, NA), y = c(3, NA))

# modify scales using gf_refine()
gf_jitter(Sepal.Length ~ Sepal.Width, color = ~Species, data = iris) \%>\%
  gf_refine(scale_color_brewer(type = "qual", palette = 3)) \%>\%
  gf_theme(theme_bw())

gf_jitter(Sepal.Length ~ Sepal.Width, color = ~Species, data = iris) \%>\%
  gf_refine(scale_color_manual(values = c("red", "navy", "limegreen"))) \%>\%
  gf_theme(theme_bw())
}
