% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-hilbert-outline.R
\name{geom_hilbert_outline}
\alias{geom_hilbert_outline}
\title{Hilbert curve outline}
\usage{
geom_hilbert_outline(
  mapping = NULL,
  data = NULL,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
Computes and draws the outline of the Hilbert curve used to map IP data to
the Cartesian plane. By superimposing this outline on top of a ggip plot,
it guides the eye to regions that are close in IP address space.
}
\section{Aesthetics}{

\code{geom_curve_outline()} understands the following aesthetics:
\itemize{
\item \code{ip}: An \code{\link[ipaddress:ip_network]{ip_network}} column. By default, the
entire Hilbert curve is shown.
\item \code{curve_order}: How nested is the curve? (default: \code{3}).
\item \code{closed}: Should the curve outline have closed ends? (default: \code{FALSE}).
\item \code{alpha}
\item \code{colour}
\item \code{linetype}
\item \code{linewidth}
}
}

\section{Computed variables}{


\describe{
\item{x, y}{The start coordinates for the segment}
\item{xend, yend}{The end coordinates for the segment}
}
}

\examples{
p <- ggplot() + coord_ip() + theme_ip_light()

# default shows curve across entire canvas
p + geom_hilbert_outline()

# only show subnetwork
p + geom_hilbert_outline(ip = ip_network("128.0.0.0/2"))

# increased nesting
p + geom_hilbert_outline(curve_order = 4)

# show multiple networks
df <- data.frame(
  ip = ip_network(c("0.0.0.0/2", "128.0.0.0/4")),
  curve_order = c(4, 5),
  closed = c(FALSE, TRUE)
)
p + geom_hilbert_outline(
  aes(ip = ip, curve_order = curve_order, closed = closed),
  data = df
)
}
