% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph.R
\name{ggiraph}
\alias{ggiraph}
\title{ggiraph}
\usage{
ggiraph(code, pointsize = 12, width = "70\%", height = "400px",
  width_svg = 6, height_svg = 6, tooltip_extra_css, hover_css,
  tooltip_opacity = 0.9, tooltip_offx = 10, tooltip_offy = 0,
  zoom_max = 1, selection_type = "multiple", selected_css, ...)
}
\arguments{
\item{code}{Plotting code to execute}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12.}

\item{width, height}{widget width and height in css unit}

\item{width_svg, height_svg}{svg viewbox width and height in inches}

\item{tooltip_extra_css}{extra css (added to \code{position: absolute;pointer-events: none;})
used to customize tooltip area.}

\item{hover_css}{css to apply when mouse is hover and element with a data-id attribute.}

\item{tooltip_opacity}{tooltip opacity}

\item{tooltip_offx}{tooltip x offset}

\item{tooltip_offy}{tooltip y offset}

\item{zoom_max}{maximum zoom factor}

\item{selection_type}{row selection mode ("single", "multiple", "none")
when widget is in a Shiny application.}

\item{selected_css}{css to apply when element is selected (shiny only).}

\item{...}{arguments passed on to \code{\link[rvg]{dsvg}}}
}
\description{
Create an interactive graphic
to be used in a web browser.
}
\examples{
# ggiraph simple example -------
# create dataset
dataset = iris
dataset$tooltip = dataset$Species
dataset$clickjs = paste0("alert(\\"",dataset$Species, "\\")" )

# plots
gg_point = ggplot(dataset, aes(x = Sepal.Length, y = Petal.Width,
		color = Species, tooltip = tooltip, onclick = clickjs) ) +
	geom_point_interactive()

ggiraph(code = {print(gg_point)})
}
\seealso{
\code{\link{geom_path_interactive}},
\code{\link{geom_point_interactive}},
\code{\link{geom_polygon_interactive}},
\code{\link{geom_rect_interactive}},
\code{\link{geom_segment_interactive}}
}

