% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_text_repel_interactive.R
\name{geom_text_repel_interactive}
\alias{geom_text_repel_interactive}
\alias{geom_label_repel_interactive}
\title{Create interactive repulsive textual annotations}
\usage{
geom_text_repel_interactive(...)

geom_label_repel_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \code{\link[=interactive_parameters]{interactive_parameters()}}.}
}
\description{
The geometries are based on \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_text_repel()}} and \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}}.
See the documentation for those functions for more details.
}
\note{
The \code{ggrepel} package is required for these geometries
}
\section{Details for geom_*_interactive functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[=aes]{aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive repulsive texts to a ggplot -------
library(ggplot2)
library(ggiraph)

# geom_text_repel_interactive
if (requireNamespace("ggrepel", quietly = TRUE)) {
  dataset = mtcars
  dataset$label = row.names(mtcars)
  dataset$tooltip = paste0(dataset$label, "<br/>", "cyl: ", dataset$cyl, "<br/>",
                           "gear: ", dataset$gear, "<br/>",
                           "carb: ", dataset$carb)
  p <- ggplot(dataset, aes(wt, mpg, color = qsec ) ) +
    geom_point_interactive(aes(tooltip = tooltip, data_id = label))

  gg_text = p +
    geom_text_repel_interactive(
      aes(label = label, tooltip = tooltip, data_id = label),
      size = 3
    )

  x <- girafe(ggobj = gg_text)
  x <- girafe_options(x = x,
                      opts_hover(css = "fill:#FF4C3B;") )
  if (interactive()) print(x)
}

# geom_label_repel_interactive
if (requireNamespace("ggrepel", quietly = TRUE)) {
  gg_label = p +
    geom_label_repel_interactive(
      aes(label = label, tooltip = tooltip, data_id = label),
      size = 3,
      max.overlaps = 12
    )

  x2 <- girafe(ggobj = gg_label)
  x2 <- girafe_options(x = x2,
                      opts_hover(css = ggiraph::girafe_css(
                       css = ";",
                       area = "fill:#FF4C3B;"
                      )) )
  if (interactive()) print(x2)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
