% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggCor.R
\name{ggCor}
\alias{ggCor}
\title{Draw a heatmap of correlation test}
\usage{
ggCor(data, label = 0, colors = NULL, title = FALSE,
  interactive = FALSE, ...)
}
\arguments{
\item{data}{A data.frame}

\item{label}{if 0, no label(default), if 1, use r value as label, if 2, use r value with significant mark as label}

\item{colors}{colors for low, mid and high correlation values}

\item{title}{if true, add title to the heatmap}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{...}{further arguments to be passed to cor.test}
}
\description{
Draw a heatmap of correlation test
}
\examples{
require(mycor)
require(ggplot2)
require(ggiraph)
ggCor(iris)
ggCor(iris,label=2,interactive=TRUE)
ggCor(mtcars,interactive=TRUE)
ggCor(iris,method="pearson",interactive=TRUE)
}

