% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\alias{geocodeQueryCheck}
\title{Geocode}
\usage{
geocode(location, output = c("latlon", "latlona", "more", "all"),
  messaging = FALSE, sensor = FALSE, override_limit = FALSE,
  client = "", signature = "", data)

geocodeQueryCheck(userType = "free")
}
\arguments{
\item{location}{a character string specifying a location of interest
(e.g. "Baylor University")}

\item{output}{amount of output}

\item{messaging}{turn messaging on/off}

\item{sensor}{whether or not the geocoding request comes from a device
with a location sensor}

\item{override_limit}{override the current query count (.GoogleGeocodeQueryCount)}

\item{client}{client ID for business users, see
\url{https://developers.google.com/maps/documentation/business/webservices/auth}}

\item{signature}{signature for business users, see
\url{https://developers.google.com/maps/documentation/business/webservices/auth}}

\item{data}{a data frame}

\item{userType}{User type, "free" or "business"}
}
\value{
If \code{output} is "latlon", "latlona", or "more", a data frame.
  If all, a list.
}
\description{
Geocodes a location (find latitude and longitude) using Google Maps.
Note that in most cases by using this function you are agreeing to the
Google Maps API Terms of Service at
\url{https://developers.google.com/maps/terms}.
}
\details{
Note that the google maps api limits to 2500 queries a day. Use
\code{geocodeQueryCheck} to determine how many queries remain.
}
\examples{
# Types of input
geocode('Baylor University')
geocode('1600 Pennsylvania Avenue, Washington DC')
geocode('the white house')
geocode(c('baylor university', 'salvation army waco'))

# Types of output
geocode('Baylor University', output = "latlona")
geocode('Baylor University', output = "more")
str(geocode('Baylor University', output = "all"))

# See how many requests we have left
geocodeQueryCheck()
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
\seealso{
\url{http://code.google.com/apis/maps/documentation/geocoding/}
}

