% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/route.R
\name{route}
\alias{route}
\title{Grab a route from Google}
\usage{
route(from, to, mode = c("driving", "walking", "bicycling", "transit"),
  structure = c("legs", "route"), output = c("simple", "all"),
  alternatives = FALSE, messaging = FALSE, sensor = FALSE,
  override_limit = FALSE)
}
\arguments{
\item{from}{name of origin addresses in a data frame (vector accepted)}

\item{to}{name of destination addresses in a data frame (vector accepted)}

\item{mode}{driving, bicycling, walking, or transit}

\item{structure}{structure of output, see examples}

\item{output}{amount of output}

\item{alternatives}{should more than one route be provided?}

\item{messaging}{turn messaging on/off}

\item{sensor}{whether or not the geocoding request comes from a device with a location sensor}

\item{override_limit}{override the current query count (.GoogleRouteQueryCount)}
}
\value{
a data frame (output='simple') or all of the geocoded information (output='all')
}
\description{
Grab a route from Google. Note that in most cases by using this function you are agreeing to the Google Maps API Terms of Service at https://developers.google.com/maps/terms.
}
\examples{
from <- 'houson, texas'
to <- 'waco, texas'
route_df <- route(from, to, structure = 'route')
qmap('college station, texas', zoom = 8) +
  geom_path(
    aes(x = lon, y = lat),  colour = 'red', size = 1.5,
    data = route_df, lineend = 'round'
  )

qmap('college station, texas', zoom = 6) +
  geom_path(
    aes(x = lon, y = lat), colour = 'red', size = 1.5,
    data = route_df, lineend = 'round'
  )

routeQueryCheck()


\dontrun{
# added for R check brevity

(legs_df <- route(
  'marrs mclean science, baylor university',
  '220 south 3rd street, waco, tx 76701', # ninfa's
  alternatives = TRUE))

qmap('424 clay avenue, waco, tx', zoom = 15, maprange = TRUE, maptype = 'hybrid',
    base_layer = ggplot(aes(x = startLon, y = startLat), data = legs_df)) +
  geom_leg(
    aes(x = startLon, y = startLat, xend = endLon, yend = endLat, colour = route),
    alpha = 3/4, size = 2, data = legs_df
  ) +
  scale_x_continuous(breaks = pretty(c(-97.1325,-97.119),4), lim = c(-97.1325,-97.119)) +
  facet_wrap(~ route) + theme_bw() +
  labs(x = 'Longitude', y = 'Latitude', colour = 'Routes')

}
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
\seealso{
\url{https://developers.google.com/maps/documentation/directions/}, \code{\link{legs2route}}, \code{\link{routeQueryCheck}}, \code{\link{geom_leg}}
}

