% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_navermap.R
\name{get_navermap}
\alias{get_navermap}
\title{Get a Naver Map}
\usage{
get_navermap(center = c(lon = 126.9849208, lat = 37.5664519), zoom = 4,
  size = c(640, 640), format = c("png", "jpeg", "jpg"),
  crs = c("EPSG:4326", "NHN:2048", "NHN:128", "EPSG:4258", "EPSG:4162",
  "EPSG:2096", "EPSG:2097", "EPSG:2098", "EPSG:900913"),
  baselayer = c("default", "satellite"), color = c("color", "bw"),
  overlayers = c("anno_satellite", "bicycle", "roadview", "traffic"), markers,
  key, uri, filename = "ggmapTemp", messaging = FALSE, urlonly = FALSE,
  force = FALSE, where = tempdir(), archiving = TRUE, ...)
}
\arguments{
\item{center}{the center of the map.  this can be longitude/latitude numeric vector.}

\item{zoom}{map zoom, an integer from 1 to 14 (building), default value 10}

\item{size}{rectangular dimensions of map in pixels - horizontal x vertical - with a max of c(640, 640).}

\item{format}{character string providing image format - png, jpeg(jpg) formats available in various flavors}

\item{crs}{Coordinate system, this currently supports EPSG:4326}

\item{baselayer}{base layer, this can be either "default", "satellite".}

\item{color}{color or black-and-white}

\item{overlayers}{overlay layers, this can be "anno_satellite","bicycle", "roadview", "traffic".}

\item{markers}{data.frame with first column longitude, second column latitude, for which naver markers should be embedded in the map image, or character string to be passed directly to api}

\item{key}{key code from naver api center}

\item{uri}{registered host url}

\item{filename}{destination file for download (file extension added according to format)}

\item{messaging}{turn messaging on/off}

\item{urlonly}{return url only}

\item{force}{if the map is on file, should a new map be looked up?}

\item{where}{where should the file drawer be located (without terminating "/")}

\item{archiving}{use archived maps.  note: by changing to TRUE you agree to abide by any of the rules governing caching naver maps}

\item{...}{...}
}
\description{
\code{get_navermap} accesses the Naver Static Maps API version 1.1 to
download a static map. Note that in most cases by using this function you
are agreeing to the Naver Maps API Terms of Service at
\url{http://dev.naver.com/openapi/apis/map/staticmap}.
}
\examples{

\dontrun{
# not run to reduce R CMD check time

map <- get_navermap(key="c75a09166a38196955adee04d3a51bf8", uri="www.r-project.org")
ggmap(map)

}
}
\author{
Heewon Jeon \email{madjakarta@gmail.com}
}
\seealso{
\url{http://dev.naver.com/openapi/apis/map/staticmap/}, \code{\link{ggmap}}
}

