% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gglocator.R
\name{gglocator}
\alias{gglocator}
\title{Locator for ggplot objects}
\usage{
gglocator(n = 1, message = FALSE, mercator = TRUE, ...)
}
\arguments{
\item{n}{number of points to locate.}

\item{message}{unused}

\item{mercator}{logical flag; should the plot be treated as using the
projection common to most web map services? Set to FALSE if the axes on the
plot use a linear scale.}

\item{...}{additional arguments (including deprecated, e.g. xexpand)}
}
\value{
a data frame with columns according to the x and y aesthetics
}
\description{
Locator for ggplot objects (Note : only accurate when extent = "normal" when
using ggmap.)
}
\examples{

if (interactive()) {

# only run for interactive sessions
df <- expand.grid(x = 0:-5, y = 0:-5)

ggplot(df, aes(x, y)) + geom_point() +
  annotate(geom = "point", x = -2, y = -2, colour = "red")

(pt <- gglocator(mercator = FALSE)) # click red point

last_plot() +
  annotate("point", pt$x, pt$y, color = "blue", size = 3, alpha = .5)

hdf <- get_map("houston, texas")
ggmap(hdf, extent = "normal")
(pt <- gglocator(mercator = TRUE))
last_plot() +
  annotate("point", pt$lon, pt$lat, color = "blue", size = 3, alpha = .5)

}


}
\author{
Tyler Rinker, Baptiste Auguie, DWin, David Kahle, \@Nikolai-Hlubek
and \@mvkorpel.
}
