% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stadiamap.R
\name{get_stadiamap}
\alias{get_stadiamap}
\title{Get a Map from Stadia Maps}
\usage{
get_stadiamap(
  bbox = c(left = -95.80204, bottom = 29.38048, right = -94.92313, top = 30.14344),
  zoom = 10,
  maptype = STADIA_VALID_MAP_TYPES,
  crop = TRUE,
  messaging = FALSE,
  urlonly = FALSE,
  color = c("color", "bw"),
  force = FALSE,
  where = tempdir(),
  ...
)
}
\arguments{
\item{bbox}{a bounding box in the format c(lowerleftlon, lowerleftlat,
upperrightlon, upperrightlat).}

\item{zoom}{a zoom level}

\item{maptype}{stamen_terrain, stamen_toner, stamen_toner_lite, stamen_watercolor,
stamen_terrain_background, stamen_toner_background,
stamen_terrain_lines, stamen_terrain_labels,
stamen_toner_lines, stamen_toner_labels.}

\item{crop}{crop raw map tiles to specified bounding box. if FALSE, the
resulting map will more than cover the bounding box specified.}

\item{messaging}{turn messaging on/off}

\item{urlonly}{return url only}

\item{color}{color or black-and-white (use force = TRUE if you've already
downloaded the images)}

\item{force}{if the map is on file, should a new map be looked up?}

\item{where}{where should the file drawer be located (without terminating
"/")}

\item{...}{...}
}
\value{
a ggmap object (a classed raster object with a bounding box
attribute)
}
\description{
\code{\link[=get_stadiamap]{get_stadiamap()}} accesses a tile server for Stadia Maps and
downloads/stitches map tiles/formats a map image.
}
\examples{

\dontrun{ requires a Stadia Maps API key. see ?register_stadiamaps


## basic usage
########################################

bbox <- c(left = -97.1268, bottom = 31.536245, right = -97.099334, top = 31.559652)

ggmap(get_stadiamap(bbox, zoom = 13))
ggmap(get_stadiamap(bbox, zoom = 14))
ggmap(get_stadiamap(bbox, zoom = 15))
ggmap(get_stadiamap(bbox, zoom = 17, messaging = TRUE))

place <- "mount everest"
(google <- get_googlemap(place, zoom = 9))
ggmap(google)
bbox_everest <- c(left = 86.05, bottom = 27.21, right = 87.81, top = 28.76)
ggmap(get_stadiamap(bbox_everest, zoom = 9))



## map types
########################################

place <- "rio de janeiro"
google <- get_googlemap(place, zoom = 10)
ggmap(google)

bbox <- bb2bbox(attr(google, "bb"))

get_stadiamap(bbox, maptype = "stamen_terrain")            \%>\% ggmap()
get_stadiamap(bbox, maptype = "stamen_terrain_background") \%>\% ggmap()
get_stadiamap(bbox, maptype = "stamen_terrain_labels")     \%>\% ggmap()
get_stadiamap(bbox, maptype = "stamen_terrain_lines")      \%>\% ggmap()
get_stadiamap(bbox, maptype = "stamen_toner")              \%>\% ggmap()
get_stadiamap(bbox, maptype = "stamen_toner_background")   \%>\% ggmap()
get_stadiamap(bbox, maptype = "stamen_toner_labels")       \%>\% ggmap()
get_stadiamap(bbox, maptype = "stamen_toner_lines")        \%>\% ggmap()
get_stadiamap(bbox, maptype = "stamen_toner_lite")         \%>\% ggmap()
get_stadiamap(bbox, maptype = "stamen_watercolor")         \%>\% ggmap()


## zoom levels
########################################

get_stadiamap(bbox, maptype = "stamen_watercolor", zoom = 11) \%>\% ggmap(extent = "device")
get_stadiamap(bbox, maptype = "stamen_watercolor", zoom = 12) \%>\% ggmap(extent = "device")
get_stadiamap(bbox, maptype = "stamen_watercolor", zoom = 13) \%>\% ggmap(extent = "device")
# get_stadiamap(bbox, maptype = "stamen_watercolor", zoom = 14) \%>\% ggmap(extent = "device")
# get_stadiamap(bbox, maptype = "stamen_watercolor", zoom = 15) \%>\% ggmap(extent = "device")
# get_stadiamap(bbox, maptype = "stamen_watercolor", zoom = 16) \%>\% ggmap(extent = "device")
# get_stadiamap(bbox, maptype = "stamen_watercolor", zoom = 17) \%>\% ggmap(extent = "device")
# get_stadiamap(bbox, maptype = "stamen_watercolor", zoom = 18) \%>\% ggmap(extent = "device")

## more examples
########################################

gc <- geocode("rio de janeiro")

get_stadiamap(bbox, zoom = 10) \%>\% ggmap() +
 geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)

get_stadiamap(bbox, zoom = 10, crop = FALSE) \%>\% ggmap() +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)

get_stadiamap(bbox, zoom = 10, maptype = "stamen_watercolor") \%>\% ggmap() +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)

get_stadiamap(bbox, zoom = 10, maptype = "stamen_toner") \%>\% ggmap() +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)


# continental united states labels
c("left" = -125, "bottom" = 25.75, "right" = -67, "top" = 49) \%>\%
  get_stadiamap(zoom = 5, maptype = "stamen_toner_labels") \%>\%
  ggmap()




# accuracy check - white house
gc <- geocode("the white house")

qmap("the white house", zoom = 16)  +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 3)

qmap("the white house", zoom = 16, source = "stadia", maptype = "stamen_terrain")  +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 3)



## known issues
########################################

# Stamen's original tilesets were raster renders built up over time, but have not been
# actively rendered for several years. As a consequence, some tiles simply do not exist,
# particularly at high zoom levels.
#
# The newer styles have been redesigned and are now generated live by Stadia Maps, so
# these are complete, but at the time of this writing, the Watercolor style is still incomplete.
}
}
\seealso{
\url{https://docs.stadiamaps.com/themes/}, \code{\link[=ggmap]{ggmap()}}
}
