% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnestedpie.R
\name{ggnestedpie}
\alias{ggnestedpie}
\title{Create nested pie plot.}
\usage{
ggnestedpie(
  data,
  group_key = NULL,
  count_type = c("count", "full"),
  r0 = 0.5,
  r1 = 1.5,
  r2 = 2.5,
  inner_thick = 1,
  outer_thick = 1,
  inner_fill_color = NULL,
  inner_label = TRUE,
  inner_label_info = c("count", "ratio", "all"),
  inner_label_color = "black",
  inner_label_split = "[[:space:]]+",
  inner_labal_threshold = NULL,
  inner_label_size = 4,
  outer_fill_color = NULL,
  outer_label_type = c("circle", "horizon", "none"),
  outer_label_pos = c("in", "out"),
  outer_label_info = c("count", "ratio", "all"),
  outer_label_split = "[[:space:]]+",
  outer_label_color = "black",
  outer_label_gap = 0.05,
  outer_labal_threshold = NULL,
  outer_label_size = 4,
  border_color = "black"
)
}
\arguments{
\item{data}{Data frame contains full data or summarized data.}

\item{group_key}{Column used to summarize the data. Default: NULL.}

\item{count_type}{Data frame type, chosen from "count" and "full". "count" means summarized data and "full" means full data. Default: count.}

\item{r0}{The radius of inner blank circle. Default: 0.5 (donut plot). When set to 0, inner plot is pie.}

\item{r1}{The radius of inner pie plot. Default: 1.5.}

\item{r2}{The radius of outer pie plot. Default: 2.5.}

\item{inner_thick}{The width of inner pie plot. Default: 1.}

\item{outer_thick}{The width of outer pie plot. Default: 1.}

\item{inner_fill_color}{Colors used for inner pie plot. Default: NULL (conduct automatic selection).}

\item{inner_label}{Logical value, whether to show label on inner pie label. Default: TRUE.}

\item{inner_label_info}{Label information type of inner pie plot, chosen from count, ratio and all (count and ratio). Default: count.}

\item{inner_label_color}{Color of the label on inner pie. Default: black.}

\item{inner_label_split}{Pattern used to split the label of inner pie, support regular expression. Default: space.}

\item{inner_labal_threshold}{Threashold of the ratio to determine label or not on inner pie. Default: NULL.}

\item{inner_label_size}{Size of the label on inner pie. Default: 4.}

\item{outer_fill_color}{Colors used for outer pie plot. Default: NULL (conduct automatic selection).}

\item{outer_label_type}{Label style of outer pie plot, chosen from circle, horizon and none (no label). Default: circle.}

\item{outer_label_pos}{Label position of outer pie, chosen from in and out. Default: in.}

\item{outer_label_info}{Label information type of outer pie plot, chosen from count, ratio and all (count and ratio). Default: count.}

\item{outer_label_split}{Pattern used to split the label of outer pie, support regular expression. Default: space.}

\item{outer_label_color}{Color of the label on outer pie. Default: black.}

\item{outer_label_gap}{Gap between label and outer pie plot, used when \code{outer_label_pos} is out.}

\item{outer_labal_threshold}{Threashold of the ratio to determine label position (in/out pie). Default: NULL.}

\item{outer_label_size}{Size of the label on outer pie. Default: 4.}

\item{border_color}{Border color. Default: black.}
}
\value{
A ggplot2 object.
}
\description{
Create nested pie plot.
}
\examples{
library(ggpie)
library(ggplot2)
data(diamonds)
# inner circle label, outer circle label and in pie plot
ggnestedpie(
  data = diamonds, group_key = c("cut", "color"), count_type = "full",
  inner_label_info = "all", inner_label_split = NULL,
  outer_label_type = "circle", outer_label_pos = "in", outer_label_info = "all"
)
# inner circle label, outer circle label and in pie plot, remove fraction below 1 of inner pie
ggnestedpie(
  data = diamonds, group_key = c("cut", "color"), count_type = "full",
  inner_label_info = "all", inner_label_split = NULL,
  inner_labal_threshold = 1, inner_label_size = 3,
  outer_label_type = "circle", outer_label_pos = "in", outer_label_info = "all"
)
# inner circle label, outer circle label and out of pie plot
ggnestedpie(
  data = diamonds, group_key = c("cut", "color"), count_type = "full",
  inner_label_info = "all", inner_label_split = NULL,
  outer_label_type = "circle", outer_label_pos = "out", outer_label_info = "all"
)
# inner circle label and no split, outer horizon label and out of pie plot,
# remove fraction below 1 of inner pie
ggnestedpie(
  data = diamonds, group_key = c("cut", "color"), count_type = "full",
  inner_label_info = "all", inner_label_split = NULL,
  inner_labal_threshold = 1, inner_label_size = 3,
  outer_label_type = "horizon", outer_label_pos = "out", outer_label_info = "all"
)
# inner circle label and no split, outer horizon label and in pie plot,
# remove fraction below 1 of inner pie,
# adjust fraction below 10 to out of pie of outer pie plot.
ggnestedpie(
  data = diamonds, group_key = c("cut", "color"), count_type = "full",
  inner_label_info = "all", inner_label_split = NULL,
  inner_labal_threshold = 1, inner_label_size = 3,
  outer_label_type = "horizon", outer_label_pos = "in",
  outer_label_info = "all", outer_labal_threshold = 10
)
# create blank between inner and outer pie
ggnestedpie(
  data = diamonds, group_key = c("cut", "color"), count_type = "full", r0 = 0.5, r1 = 1.5, r2 = 2.6,
  inner_label_info = "all", inner_label_split = NULL,
  inner_labal_threshold = 1, inner_label_size = 3,
  outer_label_type = "horizon", outer_label_pos = "in",
  outer_label_info = "all", outer_labal_threshold = 10
)
}
