% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.r
\name{ggsave}
\alias{ggsave}
\title{Save a ggplot (or other grid object) with sensible defaults}
\usage{
ggsave(filename, plot = last_plot(), device = NULL, path = NULL,
  scale = 1, width = NA, height = NA, units = c("in", "cm", "mm"),
  dpi = 300, limitsize = TRUE, ...)
}
\arguments{
\item{filename}{File name to create on disk.}

\item{plot}{Plot to save, defaults to last plot displayed.}

\item{device}{Device to use (function or any of the recognized extensions,
e.g. \code{"pdf"}). By default, extracted from filename extension.
\code{ggsave} currently recognises eps/ps, tex (pictex), pdf, jpeg, tiff,
png, bmp, svg and wmf (windows only).}

\item{path}{Path to save plot to (combined with filename).}

\item{scale}{Multiplicative scaling factor.}

\item{width, height}{Plot dimensions, defaults to size of current graphics
device.}

\item{units}{Units for width and height when specified explicitly (in, cm,
or mm)}

\item{dpi}{Resolution used for raster outputs.}

\item{limitsize}{When \code{TRUE} (the default), \code{ggsave} will not
save images larger than 50x50 inches, to prevent the common error of
specifying dimensions in pixels.}

\item{...}{Other arguments passed on to graphics device}
}
\description{
\code{ggsave()} is a convenient function for saving a plot. It defaults to
saving the last plot that you displayed, using the size of the current
graphics device. It also guesses the type of graphics device from the
extension.
}
\examples{
\dontrun{
ggplot(mtcars, aes(mpg, wt)) + geom_point()

ggsave("mtcars.pdf")
ggsave("mtcars.png")

ggsave("mtcars.pdf", width = 4, height = 4)
ggsave("mtcars.pdf", width = 20, height = 20, units = "cm")

unlink("mtcars.pdf")
unlink("mtcars.png")

# specify device when saving to a file with unknown extension
# (for example a server supplied temporary file)
file <- tempfile()
ggsave(file, device = "pdf")
unlink(file)
}
}

