% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.r
\name{labs}
\alias{ggtitle}
\alias{labs}
\alias{xlab}
\alias{ylab}
\title{Modify axis, legend, and plot labels}
\usage{
labs(...)

xlab(label)

ylab(label)

ggtitle(label, subtitle = NULL)
}
\arguments{
\item{...}{A list of new name-value pairs. The name should either be
an aesthetic, or one of "title", "subtitle", or "caption".}

\item{label}{The text for the axis, plot title or caption below the plot.}

\item{subtitle}{the text for the subtitle for the plot which will be
displayed below the title. Leave \code{NULL} for no subtitle.}
}
\description{
Good labels are critical for making your plots accessible to a wider
audience. Ensure the axis and legend labels display the full variable name.
Use the plot \code{title} and \code{subtitle} to explain the main findings.
It's common to use the \code{caption} to provide information about the
data source.
}
\details{
You can also set axis and legend labels in the individual scales (using
the first argument, the \code{name}. I recommend doing that if you're
changing other scale options.
}
\examples{
p <- ggplot(mtcars, aes(mpg, wt, colour = cyl)) + geom_point()
p + labs(colour = "Cylinders")
p + labs(x = "New x label")

# The plot title appears at the top-left, with the subtitle
# display in smaller text underneath it
p + labs(title = "New plot title")
p + labs(title = "New plot title", subtitle = "A subtitle")

# The caption appears in the bottom-right, and is often used for
# sources, notes or copyright
p + labs(caption = "(based on data from ...)")
}

