% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fmt-tb.R
\name{stat_fmt_tb}
\alias{stat_fmt_tb}
\title{Select and slice a tibble nested in \code{data}}
\usage{
stat_fmt_tb(mapping = NULL, data = NULL, geom = "table", tb.vars = NULL,
  tb.rows = NULL, digits = 3, position = "identity", na.rm = FALSE,
  show.legend = FALSE, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{tb.vars}{character vector, optionally named, used to select and or
rename the columns of the table returned.}

\item{tb.rows}{integer vector of row indexes of rows to be retained.}

\item{digits}{integer indicating the number of significant digits to be
retained in data.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_partial_tb} selects columns and/or remanes them
  and/or slices rows from a tible nested in \code{data}. This stat is
  designed to be used to pre-process \code{tibble} objects mapped to the
  \code{label} aesthetic before adding them to a plot with
  \code{geom_table}.
}
\section{Computed variables}{
 The output of sequentially applying
  \code{\link[dplyr]{slice}} with \code{tb.rows} as argument and
  \code{\link[dplyr]{select}} with \code{tb.vars} to a list variable
  list mapped to \code{label} and containing a single tibble per row
  in \code{data}.
}

\examples{
library(ggplot2)
my.df <- tibble::tibble(x = c(1, 2),
                    y = c(0, 4),
                    group = c("A", "B"),
                    tbs = list(a = tibble::tibble(X = 1:6, Y = rep(c("x", "y"), 3)),
                               b = tibble::tibble(X = 1:3, Y = "x")))

ggplot(my.df, aes(x, y, label = tbs)) +
  stat_fmt_tb() +
  expand_limits(x = c(0,3), y = c(-2, 6))

ggplot(my.df, aes(x, y, label = tbs)) +
  stat_fmt_tb(tb.vars = c(value = "X", group = "Y"),
               tb.rows = 1:3) +
  expand_limits(x = c(0,3), y = c(-2, 6))

}
