% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-npc.r
\name{compute_npcx}
\alias{compute_npcx}
\alias{compute_npcy}
\title{Compute npc coordinates}
\usage{
compute_npcx(x, group = 1L, h.step = 0.1, margin.npc = 0.05, each.len = 1)

compute_npcy(y, group = 1L, v.step = 0.1, margin.npc = 0.05, each.len = 1)
}
\arguments{
\item{x}{numeric or if character, one of "right", "left", "centre",
"center" or "middle".}

\item{group}{integer vector, ggplot's group id. Used to shift coordinates to
avoid overlaps.}

\item{h.step, v.step}{numeric [0..1] The step size for shifting coordinates
in npc units. Usually << 1.}

\item{margin.npc}{numeric [0..1] The margin added towards the nearest
plotting area edge when converting character coordinates into npc. Usually
<< 1.}

\item{each.len}{integer The number of steps per group.}

\item{y}{numeric or if character, one of "top", "bottom", "centre",
"center" or "middle".}
}
\value{
A numeric vector with values in the range [0..1] representing
  npc coordinates.
}
\description{
Convert character-encoded positions to npc units and shift positions to
avoid overlaps when grouping is active. If numeric, validate npc values.
}
\details{
These functions use NPC (normalized plot coordinates) instead of
  data coordinates. They translate named positions into numeric values in
  [0..1] and they can also shift the position according to the group, e.g.,
  for each increase in the group number displace the position inwards or
  outwards, by a user-supplied distance. They make it possible to set
  automatically set default positions for grouped text labels.

  Out of bounds numeric values are constrained to [0..1]. Unrecognized
  character values are silently converted into \code{NA_integer_}.
}
\note{
These functions are used by several layer functions in packages
  'ggpp' and 'ggpmisc', and can be useful to developers of other 'ggplot2'
  extensions.
}
\examples{
compute_npcx("right")
compute_npcx(c("left", "right"))
compute_npcy("bottom")
compute_npcy("bottom", group = 1L:3L)
compute_npcy("bottom", group = 2L)
compute_npcx(0.5)
compute_npcx(1)

}
