% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_prism.R
\name{theme_prism}
\alias{theme_prism}
\title{Prism themes}
\usage{
theme_prism(
  palette = "black_and_white",
  base_size = 14,
  base_family = "sans",
  base_fontface = "bold",
  base_line_size = base_size/14,
  base_rect_size = base_size/14,
  axis_text_angle = 0,
  border = FALSE
)
}
\arguments{
\item{palette}{\code{string}. Palette name, use
\code{names(ggprism_data$themes)} to show all valid palette names.}

\item{base_size}{\code{numeric}. Base font size, given in \code{"pt"}.}

\item{base_family}{\code{string}. Base font family, default is \code{"sans"}.}

\item{base_fontface}{\code{string}. Base font face, default is \code{"bold"}.}

\item{base_line_size}{\code{numeric}. Base linewidth for line elements}

\item{base_rect_size}{\code{numeric}. Base linewidth for rect elements}

\item{axis_text_angle}{\code{integer}. Angle of axis text in degrees.
One of: \verb{0, 45, 90, 270}.}

\item{border}{\code{logical}. Should a border be drawn around the plot?
Clipping will occur unless e.g. \code{coord_cartesian(clip = "off")} is used.}
}
\value{
Returns a list-like object of class \emph{theme}.
}
\description{
A collection of ggplot2 themes that use palettes which mirror the
colour schemes available in GraphPad Prism.
}
\examples{
library(ggplot2)

# see ?preview_theme for a convenient function to preview ggprism themes
# before using theme_prism

## base plot
base <- ggplot(mpg, aes(x = displ, y = cty, colour = class)) +
  geom_point()

## default palette is "black_and_white"
## default base_size is 14 (compared with 11 for theme_grey)
base +
  theme_prism()

## try some other palettes
base +
  theme_prism(palette = "office")

base +
  theme_prism(palette = "flames")

## try matching the theme_prism palette with same colour palette
base +
  theme_prism(palette = "stained_glass") +
  scale_color_prism(palette = "stained_glass")

base +
  theme_prism(palette = "candy_bright") +
  scale_color_prism(palette = "candy_bright")

## change the font face
base +
  theme_prism(base_fontface = "plain")

## change the font family
base +
  theme_prism(base_family = "serif")

## base_line_size scales automatically as you change base_size
base +
  theme_prism(base_size = 10)

## but you can also change it manually
base +
  theme_prism(base_size = 16, base_line_size = 0.8)

## easily change x axis text angle
base +
  theme_prism(axis_text_angle = 45)

## add a border (need to turn off clipping)
base +
  theme_prism(border = TRUE) +
  coord_cartesian(clip = "off")

## change border thickness
base +
  theme_prism(border = TRUE, base_rect_size = 2) +
  coord_cartesian(clip = "off")
}
