% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggqqplot.R
\name{ggqqplot}
\alias{ggqqplot}
\title{QQ Plots}
\usage{
ggqqplot(data, x, color = "black", palette = NULL, size = 1,
  add = c("qqline", "none"), add.params = list(linetype = "solid"),
  conf.int = TRUE, conf.int.level = 0.95, ggtheme = theme_pubr(), ...)
}
\arguments{
\item{data}{a data frame}

\item{x}{variable to be drawn.}

\item{color}{point color.}

\item{palette}{the color palette to be used for coloring or filling by
groups. Allowed values include "grey" for grey color palettes; brewer
palettes e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue",
"red"); and scientific journal palettes from ggsci R package, e.g.: "npg", "aaas", "lancet", "jco",
"ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{size}{point size.}

\item{add}{character vector. Allowed values are one of "none" and "qqline"
(for adding qqline).}

\item{add.params}{parameters (color, size,  linetype) for the
argument 'add'; e.g.: add.params = list(color = "red").}

\item{conf.int}{logical value. If TRUE, confidence interval is added.}

\item{conf.int.level}{the confidence level. Default value is 0.95.}

\item{ggtheme}{function, ggplot2 theme name. Default value is theme_pubr().
Allowed values include ggplot2 official themes: theme_gray(), theme_bw(),
theme_minimal(), theme_classic(), theme_void(), ....}

\item{...}{other arguments to be passed to \code{\link[ggplot2]{stat_qq}} and
\code{\link{ggpar}}.}
}
\description{
Quantile-Quantile plot.
}
\details{
The plot can be easily customized using the function ggpar(). Read
  ?ggpar for changing: \itemize{ \item main title and axis labels: main,
  xlab, ylab \item axis limits: xlim, ylim (e.g.: ylim = c(0, 30)) \item axis
  scales: xscale, yscale (e.g.: yscale = "log2") \item color palettes:
  palette = "Dark2" or palette = c("gray", "blue", "red") \item legend title,
  labels and position: legend = "right" \item plot orientation : orientation
  = c("vertical", "horizontal", "reverse") }
}
\examples{
# Create some data format
set.seed(1234)
wdata = data.frame(
   sex = factor(rep(c("F", "M"), each=200)),
   weight = c(rnorm(200, 55), rnorm(200, 58)))

head(wdata, 4)

# Basic QQ plot
ggqqplot(wdata, x = "weight")

# Change colors and shape by groups ("sex")
# Use custom palette
ggqqplot(wdata, x = "weight",
   color = "sex", palette = c("#00AFBB", "#E7B800"))

}
\seealso{
\code{\link{ggpar}}
}

