% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_exec.R
\name{geom_exec}
\alias{geom_exec}
\title{Execute ggplot2 functions}
\usage{
geom_exec(geomfunc = NULL, data = NULL, position = NULL, ...)
}
\arguments{
\item{geomfunc}{a ggplot2 function (e.g.: geom_point)}

\item{data}{a data frame to be used for mapping}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{arguments accepeted by the function}
}
\value{
return a plot if geomfunc!=Null or a list(option, mapping) if
  geomfunc = NULL.
}
\description{
A helper function used by ggpubr functions to execute any geom_*
  functions in ggplot2. Useful only when you want to call a geom_* function
  without carrying about the arguments to put in aes(). Basic users of ggpubr
  don't need this function.
}
\examples{
\dontrun{
ggplot() + geom_exec(geom_point, data = mtcars,
    x = "mpg", y = "wt", size = "cyl", color = "cyl")
}
}

