% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_anova_test.R
\name{stat_anova_test}
\alias{stat_anova_test}
\title{Add Anova Test P-values to a GGPlot}
\usage{
stat_anova_test(
  mapping = NULL,
  data = NULL,
  method = c("one_way", "one_way_repeated", "two_way", "two_way_repeated",
    "two_way_mixed"),
  wid = NULL,
  group.by = NULL,
  type = NULL,
  effect.size = "ges",
  error = NULL,
  correction = c("auto", "GG", "HF", "none"),
  label = "{method}, p = {p.format}",
  label.x.npc = "left",
  label.y.npc = "top",
  label.x = NULL,
  label.y = NULL,
  step.increase = 0.1,
  p.adjust.method = "holm",
  significance = list(),
  geom = "text",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  parse = FALSE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{method}{ANOVA test methods. Possible values are one of
\code{c("one_way", "one_way_repeated", "two_way", "two_way_repeated",
"two_way_mixed")}.}

\item{wid}{(factor) column name containing individuals/subjects identifier.
Should be unique per individual. Required only for repeated measure tests
(\code{"one_way_repeated", "two_way_repeated", "friedman_test", etc}).}

\item{group.by}{(optional) character vector specifying the grouping variable;
it should be used only for grouped plots. Possible values are : \itemize{
\item \code{"x.var"}: Group by the x-axis variable and perform the test
between legend groups. In other words, the p-value is compute between legend
groups at each x position \item \code{"legend.var"}: Group by the legend
variable and perform the test between x-axis groups. In other words, the
test is performed between the x-groups for each legend level. }}

\item{type}{the type of sums of squares for ANOVA. Allowed values are either
1, 2 or 3. \code{type = 2} is the default because this will yield identical
ANOVA results as type = 1 when data are balanced but type = 2 will
additionally yield various assumption tests where appropriate. When the data
are unbalanced the \code{type = 3} is used by popular commercial softwares
including SPSS.}

\item{effect.size}{the effect size to compute and to show in the ANOVA
results. Allowed values can be either "ges" (generalized eta squared) or
"pes" (partial eta squared) or both. Default is "ges".}

\item{error}{(optional) for a linear model, an lm model object from which the
overall error sum of squares and degrees of freedom are to be calculated.
Read more in \code{\link[car]{Anova}()} documentation.}

\item{correction}{character. Used only in repeated measures ANOVA test to
specify which correction of the degrees of freedom should be reported for
the within-subject factors. Possible values are: \itemize{ \item{"GG"}:
applies Greenhouse-Geisser correction to all within-subjects factors even if
the assumption of sphericity is met (i.e., Mauchly's test is not
significant, p > 0.05). \item{"HF"}: applies Hyunh-Feldt correction to all
within-subjects factors even if the assumption of sphericity is met,
\item{"none"}: returns the ANOVA table without any correction and
\item{"auto"}: apply automatically GG correction to only within-subjects
factors violating the sphericity assumption (i.e., Mauchly's test p-value is
significant, p <= 0.05). }}

\item{label}{character string specifying label. Can be: \itemize{ \item the
column containing the label (e.g.: \code{label = "p"} or \code{label =
"p.adj"}), where \code{p} is the p-value. Other possible values are
\code{"p.signif", "p.adj.signif", "p.format", "p.adj.format"}. \item an
expression that can be formatted by the \code{\link[glue]{glue}()} package.
For example, when specifying \code{label = "Anova, p = \{p\}"}, the
expression \{p\} will be replaced by its value. \item a combination of
plotmath expressions and glue expressions. You may want some of the
statistical parameter in italic; for example:\code{label = "Anova, italic(p)
= {p}"}. \item a constant: \code{label = "as_italic"}: display statistical
parameters in italic; \code{label = "as_detailed"}: detailed plain text;
\code{label = "as_detailed_expression"} or \code{label =
"as_detailed_italic"}: detailed plotmath expression. Statistical parameters
will be displayed in italic.}.}

\item{label.x.npc, label.y.npc}{can be \code{numeric} or \code{character}
vector of the same length as the number of groups and/or panels. If too
short they will be recycled. \itemize{ \item If \code{numeric}, value should
be between 0 and 1. Coordinates to be used for positioning the label,
expressed in "normalized parent coordinates". \item If \code{character},
allowed values include: i) one of c('right', 'left', 'center', 'centre',
'middle') for x-axis; ii) and one of c( 'bottom', 'top', 'center', 'centre',
'middle') for y-axis.}}

\item{label.x, label.y}{\code{numeric} Coordinates (in data units) to be used
for absolute positioning of the label. If too short they will be recycled.}

\item{step.increase}{numeric value in with the increase in fraction of total
height for every additional comparison to minimize overlap. The step value
can be negative to reverse the order of groups.}

\item{p.adjust.method}{method for adjusting p values (see
\code{\link[stats]{p.adjust}}).  Has impact only in a situation, where
multiple pairwise tests are performed; or when there are multiple grouping
variables. Allowed values include "holm", "hochberg", "hommel",
"bonferroni", "BH", "BY", "fdr", "none". If you don't want to adjust the p
value (not recommended), use p.adjust.method = "none".}

\item{significance}{a list of arguments specifying the signifcance cutpoints
 and symbols. For example, \code{significance <- list(cutpoints = c(0,
 0.0001, 0.001, 0.01, 0.05, Inf), symbols = c("****", "***", "**", "*",
 "ns"))}.

 In other words, we use the following convention for symbols indicating
 statistical significance: \itemize{ \item \code{ns}: p > 0.05 \item
 \code{*}: p <= 0.05 \item \code{**}: p <= 0.01 \item \code{***}: p <= 0.001
 \item \code{****}:  p <= 0.0001 }}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{na.rm}{If FALSE (the default), removes missing values with a warning. If
TRUE silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE} (the default for most ggpubr functions), 
overrides the default aesthetics, rather than combining with them. This is 
most useful for helper functions that define both data and aesthetics and 
shouldn't inherit behaviour from the default plot specification. Set to 
\code{TRUE} to inherit aesthetics from the parent ggplot layer.}

\item{parse}{If TRUE, the labels will be parsed into expressions and displayed
as described in \code{?plotmath}.}

\item{...}{other arguments to pass to
\code{\link[ggplot2:geom_text]{geom_text}}, such as:\itemize{ \item
\code{hjust}: horizontal justification of the text. Move the text left or
right and \item \code{vjust}: vertical justification of the text. Move the
text up or down. }}
}
\description{
Adds automatically one-way and two-way ANOVA test p-values to a
 ggplot, such as box blots, dot plots and stripcharts.
}
\section{Computed variables}{
 \itemize{ \item{DFn}: Degrees of Freedom in the
 numerator (i.e. DF effect). \item{DFd}:	Degrees of Freedom in the
 denominator (i.e., DF error). \item{ges}:	Generalized Eta-Squared measure of
 effect size. Computed only when the option \code{effect.size = "ges"}.
 \item{pes}:	Partial Eta-Squared measure of effect size. Computed only when
 the option \code{effect.size = "pes"}. \item{F}:	F-value. \item{p}:	p-value.
 \item{p.adj}: Adjusted p-values. \item{p.signif}: P-value significance.
 \item{p.adj.signif}: Adjusted p-value significance. \item{p.format}:
 Formated p-value. \item{p.adj.format}: Formated adjusted p-value. \item{n}:
 number of samples. }
}

\examples{
# Data preparation
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Transform `dose` into factor variable
df <- ToothGrowth
df$dose <- as.factor(df$dose)
# Add individuals id
df$id <- rep(1:10, 6)
# Add a random grouping variable
set.seed(123)
df$group <- sample(factor(rep(c("grp1", "grp2", "grp3"), 20)))
df$len <- ifelse(df$group == "grp2", df$len+2, df$len)
df$len <- ifelse(df$group == "grp3", df$len+7, df$len)
head(df, 3)


# Basic boxplot
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Create a basic boxplot
# Add 5\% and 10\% space to the plot bottom and the top, respectively
bxp <- ggboxplot(df, x = "dose", y = "len") +
  scale_y_continuous(expand = expansion(mult = c(0.05, 0.1)))

# Add the p-value to the boxplot
bxp + stat_anova_test()

\dontrun{
# Change the label position
# Using coordinates in data units
bxp + stat_anova_test(label.x = "1", label.y = 10, hjust = 0)
}

# Format the p-value differently
custom_p_format <- function(p) {
  rstatix::p_format(p, accuracy = 0.0001, digits = 3, leading.zero = FALSE)
}
bxp + stat_anova_test(
  label = "Anova, italic(p) = {custom_p_format(p)}{p.signif}"
)

# Show a detailed label in italic
bxp + stat_anova_test(label = "as_detailed_italic")


# Faceted plots
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Create a ggplot facet
bxp <- ggboxplot(df, x = "dose", y = "len", facet.by = "supp") +
  scale_y_continuous(expand = expansion(mult = c(0.05, 0.1)))
# Add p-values
bxp + stat_anova_test()


# Grouped plots
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
bxp2 <- ggboxplot(df, x = "group", y = "len", color = "dose", palette = "npg")

# For each x-position, computes tests between legend groups
bxp2 + stat_anova_test(aes(group = dose), label = "p = {p.format}{p.signif}")

#  For each legend group, computes tests between x variable groups
bxp2 + stat_anova_test(aes(group = dose, color = dose), group.by = "legend.var")


\dontrun{
# Two-way ANOVA: Independent measures
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Visualization: box plots with p-values
# Two-way interaction p-values between x and legend (group) variables
bxp3 <- ggboxplot(
  df, x = "supp", y = "len",
  color = "dose", palette = "jco"
)
bxp3 + stat_anova_test(aes(group = dose),  method = "two_way")

# One-way repeatead measures ANOVA
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
df$id <- as.factor(c(rep(1:10, 3), rep(11:20, 3)))
ggboxplot(df, x = "dose", y = "len") +
  stat_anova_test(method = "one_way_repeated", wid = "id")

# Two-way repeatead measures ANOVA
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
df$id <- as.factor(rep(1:10, 6))
ggboxplot(df, x = "dose", y = "len", color = "supp", palette = "jco") +
  stat_anova_test(aes(group = supp), method = "two_way_repeated", wid = "id")

# Grouped one-way repeated measures ANOVA
ggboxplot(df, x = "dose", y = "len", color = "supp", palette = "jco") +
  stat_anova_test(aes(group = supp, color = supp),
  method = "one_way_repeated", wid = "id", group.by = "legend.var")
 }
}
