% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseqmsplot.R
\name{ggseqmsplot}
\alias{ggseqmsplot}
\title{Modal State Sequence Plot}
\usage{
ggseqmsplot(
  seqdata,
  no.n = FALSE,
  barwidth = NULL,
  group = NULL,
  weighted = TRUE,
  with.missing = FALSE,
  border = FALSE,
  facet_ncol = NULL,
  facet_nrow = NULL
)
}
\arguments{
\item{seqdata}{State sequence object (class \code{stslist}) created with the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.}

\item{no.n}{specifies if number of (weighted) sequences is shown (default is \code{TRUE})}

\item{barwidth}{specifies width of bars (default is \code{NULL}); valid range: (0, 1]}

\item{group}{A vector of the same length as the sequence data indicating group membership. When not NULL, a distinct plot is generated for each level of group.}

\item{weighted}{Controls if weights (specified in \code{\link[TraMineR:seqdef]{TraMineR::seqdef}}) should be used. Default is \code{TRUE}, i.e. if available weights are used}

\item{with.missing}{Specifies if missing states should be considered when computing the state distributions (default is \code{FALSE}).}

\item{border}{if \code{TRUE} bars are plotted with black outline; default is \code{FALSE} (also accepts \code{NULL})}

\item{facet_ncol}{Number of columns in faceted (i.e. grouped) plot}

\item{facet_nrow}{Number of rows in faceted (i.e. grouped) plot}
}
\value{
A modal state sequence plot. If stored as object the resulting list
object also contains the data (long format) used for rendering the plot
}
\description{
Function for rendering modal state sequence plot with
\code{\link[ggplot2]{ggplot2}} \insertCite{wickham2016}{ggseqplot} instead
of base R's \code{\link[base]{plot}} function that is used by
\code{\link[TraMineR:seqplot]{TraMineR::seqplot}} \insertCite{gabadinho2011}{ggseqplot}.
}
\details{
The function uses \code{\link[TraMineR:seqmodst]{TraMineR::seqmodst}}
to obtain the modal states and their prevalence. This requires that the
input data (\code{seqdata}) are stored as state sequence object (class \code{stslist})
created with the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.

The data on the modal states and their prevalences are reshaped to be plotted with
\code{\link[ggplot2:geom_bar]{ggplot2::geom_bar}}. The data
and specifications used for rendering the plot can be obtained by storing the
plot as an object. The appearance of the plot can be adjusted just like with
every other ggplot (e.g., by changing the theme or the scale using \code{+} and
the respective functions).
}
\examples{
# Use example data from TraMineR: actcal data set
data(actcal)

# We use only a sample of 300 cases
set.seed(1)
actcal <- actcal[sample(nrow(actcal), 300), ]
actcal.lab <- c("> 37 hours", "19-36 hours", "1-18 hours", "no work")
actcal.seq <- seqdef(actcal, 13:24, labels = actcal.lab)

# modal state sequence plot; grouped by sex
# with TraMineR::seqplot
seqmsplot(actcal.seq, group = actcal$sex)
# with ggseqplot
ggseqmsplot(actcal.seq, group = actcal$sex)
# with ggseqplot and some layout changes
ggseqmsplot(actcal.seq, group = actcal$sex, no.n = TRUE, border = FALSE, facet_nrow = 2)

}
\references{
\insertAllCited{}
}
\author{
Marcel Raab
}
