% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed-aspect.R
\name{fixed_plot_aspect}
\alias{fixed_plot_aspect}
\title{Enforce a plot aspect ratio}
\usage{
fixed_plot_aspect(ratio = 1)
}
\arguments{
\item{ratio}{The desired aspect ratio (width / height)}
}
\value{
A \code{\link[ggplot2:layer]{ggplot2::layer()}} that can be added to  a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
When using a fixed-aspect coordinate system, \code{\link[=fixed_plot_aspect]{fixed_plot_aspect()}} expands
either the width or height of the plot to ensure that the output
has dimensions that make sense. This is a useful workaround for
getting reasonable-shaped plots when using \code{\link[ggplot2:coord_sf]{ggplot2::coord_sf()}}
or \code{\link[ggplot2:coord_fixed]{ggplot2::coord_fixed()}} when the data happen to be
aligned vertically or horizontally.
}
\examples{
library(ggplot2)
df <- data.frame(x =  0:5, y =  seq(0, 10, length.out = 6))
ggplot(df, aes(x, y)) +
  geom_point() +
  fixed_plot_aspect(ratio = 1) +
  coord_fixed()

}
