% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-source-spct.R
\name{scale_y_s.e.irrad_continuous}
\alias{scale_y_s.e.irrad_continuous}
\alias{scale_y_s.q.irrad_continuous}
\alias{scale_y_s.e.irrad_log10}
\alias{scale_y_s.q.irrad_log10}
\title{Spectral irradiance y-scale}
\usage{
scale_y_s.e.irrad_continuous(
  unit.exponent = 0,
  name = s.e.irrad_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = round(normalized, 1)),
  labels = SI_pl_format(exponent = unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.e.irrad"]],
  scaled = FALSE,
  normalized = FALSE,
  ...
)

scale_y_s.q.irrad_continuous(
  unit.exponent = ifelse(normalized, 0, -6),
  name = s.q.irrad_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = round(normalized, 1)),
  labels = SI_pl_format(exponent = unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.q.irrad"]],
  scaled = FALSE,
  normalized = FALSE,
  ...
)

scale_y_s.e.irrad_log10(
  unit.exponent = 0,
  name = s.e.irrad_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = round(normalized, 1)),
  labels = SI_pl_format(exponent = unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.e.irrad"]],
  scaled = FALSE,
  normalized = FALSE,
  ...
)

scale_y_s.q.irrad_log10(
  unit.exponent = ifelse(normalized, 0, -6),
  name = s.q.irrad_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = round(normalized, 1)),
  labels = SI_pl_format(exponent = unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.q.irrad"]],
  scaled = FALSE,
  normalized = FALSE,
  ...
)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{format}{character string, "R", "R.expression", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for raw detector counts.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous() +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(label.text = "") +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(label.text = "Irradiancia spectral,") +
  scale_x_wl_continuous(label.text = "Longitud de onda,")

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(unit.exponent = -1) +
  scale_x_wl_continuous()

ggplot(sun.spct, unit.out = "photon") +
  geom_line() +
  scale_y_s.q.irrad_continuous() +
  scale_x_wl_continuous()

ggplot(clip_wl(sun.spct, c(295, NA))) +
  geom_line() +
  scale_y_s.e.irrad_log10() +
  scale_x_wl_continuous()

ggplot(clip_wl(sun.spct, c(295, NA)),
  unit.out = "photon") +
  geom_line(na.rm = TRUE) +
  scale_y_s.q.irrad_log10() +
  scale_x_wl_continuous()

photon_as_default()
normalized_sun.spct <- normalize(sun.spct)
ggplot(normalized_sun.spct) +
  geom_line(na.rm = TRUE) +
  scale_y_s.q.irrad_continuous(normalized =
                            getNormalized(normalized_sun.spct)) +
  scale_x_wl_continuous()

unset_radiation_unit_default()

}
