% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-filter-spct.r
\name{A_plot}
\alias{A_plot}
\title{Create a complete ggplot for a filter spectrum.}
\usage{
A_plot(
  spct,
  w.band,
  range,
  label.qty,
  span,
  wls.target,
  annotations,
  geom,
  text.size,
  chroma.type,
  idfactor,
  facets,
  na.rm,
  ylim,
  ...
)
}
\arguments{
\item{spct}{a filter_spct object}

\item{w.band}{list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{label.qty}{character string giving the type of summary quantity to use
for labels}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{wls.target}{numeric vector indicating the spectral quantity values for
which wavelengths are to be searched and interpolated if need. The
\code{character} strings "half.maximum" and "half.range" are also accepted
as arguments. A list with \code{numeric} and/or \code{character} values is
also accepted.}

\item{annotations}{a character vector.}

\item{geom}{character.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried. If \code{idfactor=NA} no aesthetic is mapped
to the spectra and the user needs to use 'ggplot2' functions to manually
map an aesthetic or use facets for the spectra.}

\item{facets}{logical or integer Indicating if facets are to be created for
the levels of \code{idfactor} when \code{spct} contain multiple spectra in
long form.}

\item{na.rm}{logical.}

\item{ylim}{numeric y axis limits,}

\item{...}{currently ignored.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a filter_spct
object showing spectral absorbance.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\keyword{internal}
