% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/si-prefixes.R
\name{exponent2prefix}
\alias{exponent2prefix}
\alias{exponent2factor}
\alias{exponent2prefix_name}
\alias{prefix_name2exponent}
\alias{prefix2exponent}
\alias{has_SI_prefix}
\alias{nearest_SI_exponent}
\title{SI unit prefixes}
\usage{
exponent2prefix(exponent,
  char.set = getOption("photobiology.fancy.chars", default = "utf8"))

exponent2factor(exponent = 0, if.zero.exponent = "1")

exponent2prefix_name(exponent)

prefix_name2exponent(name)

prefix2exponent(prefix, char.set = getOption("photobiology.fancy.chars",
  default = "utf8"))

has_SI_prefix(exponent)

nearest_SI_exponent(exponent)
}
\arguments{
\item{exponent}{numeric The power of 10 of the unit multiplier.}

\item{char.set}{character How to encode Greek letters and other fancy
characters in prefixes: \code{"utf8"}, \code{"ascii"}, \code{"LaTeX"}.}

\item{if.zero.exponent}{character string to return when exponent is equal to zero.}

\item{name}{character Long SI name of multiplier.}

\item{prefix}{character Unit prefix used for multiplier.}
}
\description{
Convert SI unit prefixes into exponents of ten of multipliers and vice-versa.
}
\note{
To change the default \code{char.set}, set R option
  \code{"photobiology.fancy.chars"}. Implementation is based on a table of
  data and extensible to any alphabet supported by R character objects by
  expanding the table.
}
\examples{

exponent2prefix(3)
exponent2prefix(0)
exponent2prefix(-6)


exponent2factor(3)
exponent2factor(0)
exponent2factor(0, NULL)
exponent2factor(0, "")
exponent2factor(-6)

}
