% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-rangeframe.R
\docType{data}
\name{geom_rangeframe}
\alias{geom_rangeframe}
\alias{GeomRangeFrame}
\title{Range Frames}
\usage{
geom_rangeframe(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., sides = "bl", na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{sides}{A string that controls which sides of the plot the frames appear on.
It can be set to a string containing any of \code{'trbl'}, for top, right,
bottom, and left.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
Axis lines which extend to the maximum and minimum of the plotted data.
}
\section{Aesthetics}{

\itemize{
\item colour
\item size
\item linetype
\item alpha
}
}

\examples{
### Keywords: datasets


library("ggplot2")
ggplot(mtcars, aes(wt, mpg)) +
 geom_point() +
 geom_rangeframe() +
 theme_tufte()



}
\references{
Tufte, Edward R. (2001) The Visual Display of
Quantitative Information, Chapter 6.
}
\seealso{
Other geom tufte: \code{\link{geom_tufteboxplot}}
}
\keyword{datasets}
