% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_colour_ghibli_d}
\alias{scale_colour_ghibli_d}
\alias{scale_color_ghibli_d}
\alias{scale_fill_ghibli_d}
\title{Discrete scales to use for ggplot2}
\usage{
scale_colour_ghibli_d(name, direction = 1, ...)

scale_color_ghibli_d(name, direction = 1, ...)

scale_fill_ghibli_d(name, direction = 1, ...)
}
\arguments{
\item{name}{Name of desired palette.}

\item{direction}{Either `1` or `-1`. If `-1` the palette will be reversed.}

\item{...}{additional arguments to pass to discrete_scale}
}
\description{
These functions provide the option to use \code{ghibli} colours inside discrete
palettes with the `ggplot2` package.
}
\details{
Available palettes are found in \code{\link[ghibli]{ghibli_palettes}}.
}
\examples{

if (require('ggplot2')) {

  ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width, colour = Species)) +
    geom_point() +
    scale_colour_ghibli_d("PonyoMedium")
}

}
