% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghypPlots.R
\docType{methods}
\name{plot.ghyp.attrib}
\alias{plot.ghyp.attrib}
\alias{plot,ghyp.attribution,ANY-method}
\title{Plot ES contribution}
\usage{
\method{plot}{ghyp.attrib}(
  x,
  metrics = c("contribution", "sensitivity"),
  column.index = NULL,
  percentage = FALSE,
  colorset = NULL,
  horiz = FALSE,
  unstacked = TRUE,
  pie.chart = FALSE,
  sub = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{ghyp.attribution} object.}

\item{metrics}{either the \code{contribution} or \code{sensitivity} will be plotted.}

\item{column.index}{which column of the object.}

\item{percentage}{plot contribution or sensitivity in percent.}

\item{colorset}{vector of colors for the chart.}

\item{horiz}{plot horizontally.}

\item{unstacked}{unstacked plot.}

\item{pie.chart}{should a pie chart be plotted.}

\item{sub}{subtitle.}

\item{\dots}{arguments passed to \code{plot} function.}
}
\description{
These functions plot the contribution of each asset to the overall portfolio expected shortfall.
}
\examples{
\dontrun{
 data(smi.stocks)
 
 ## Fit a NIG model to Novartis, CS and Nestle log-returns
 assets.fit <- fit.NIGmv(smi.stocks[, c("Novartis", "CS", "Nestle")], silent = TRUE)
 
 ## Define Weights of the Portfolio
 weights <- c(0.2, 0.5, 0.3)
 
 ## Confidence level for Expected Shortfall
 es.levels <- c(0.01)
 portfolio.attrib <- ESghyp.attribution(alpha=es.levels, object=assets.fit, weights=weights)
 
 ## Plot Risk Contribution for each Asset
 plot(portfolio.attrib, metrics='contribution')  
}
}
\seealso{
\code{\link{ESghyp.attribution}}.
}
\author{
Marc Weibel
}
\keyword{attribution}
