% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Giac.R
\name{Giac}
\alias{Giac}
\title{R6 class to access to Giac}
\description{
Creates an object allowing to execute Giac commands.
}
\examples{

## ------------------------------------------------
## Method `Giac$execute`
## ------------------------------------------------

\donttest{if(!is.null(chromote::find_chrome())) {
  giac <- Giac$new()
  giac$execute("2 + 3/7")
  giac$execute("integrate(ln(x))")
  giac$close()
}}

## ------------------------------------------------
## Method `Giac$implicitization`
## ------------------------------------------------

library(giacR)
\donttest{if(!is.null(chromote::find_chrome())) {
  giac <- Giac$new()
  giac$implicitization(
    equations = "x = a*cost, y = b*sint",
    relations = "cost^2 + sint^2 = 1",
    variables = "cost, sint",
    constants = "a, b"
  )
  giac$close()
}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Giac-new}{\code{Giac$new()}}
\item \href{#method-Giac-execute}{\code{Giac$execute()}}
\item \href{#method-Giac-implicitization}{\code{Giac$implicitization()}}
\item \href{#method-Giac-close}{\code{Giac$close()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Giac-new"></a>}}
\if{latex}{\out{\hypertarget{method-Giac-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Giac} instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Giac$new(chromePath = find_chrome())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chromePath}}{path to the Chrome executable (or Chromium, Brave,
etc); if \code{find_chrome()} does not work, you can set the
environment variable \code{CHROMOTE_CHROME} to the path and it will
work}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Giac} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Giac-execute"></a>}}
\if{latex}{\out{\hypertarget{method-Giac-execute}{}}}
\subsection{Method \code{execute()}}{
Execute a Giac command.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Giac$execute(command, timeout = 10000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{the command to be executed given as a character string}

\item{\code{timeout}}{timeout in milliseconds}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The result of the command in a character string.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{if(!is.null(chromote::find_chrome())) {
  giac <- Giac$new()
  giac$execute("2 + 3/7")
  giac$execute("integrate(ln(x))")
  giac$close()
}}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Giac-implicitization"></a>}}
\if{latex}{\out{\hypertarget{method-Giac-implicitization}{}}}
\subsection{Method \code{implicitization()}}{
Gröbner implicitization (see examples)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Giac$implicitization(
  equations,
  relations = "",
  variables,
  constants = "",
  timeout = 10000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{equations}}{comma-separated equations}

\item{\code{relations}}{comma-separated relations, or an empty string if there
is no relation; the relations between the constants must placed first,
followed by the relations between the variables}

\item{\code{variables}}{comma-separated variables}

\item{\code{constants}}{comma-separated constants, or an empty string if there
is no constant}

\item{\code{timeout}}{timeout in milliseconds}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The implicitization of the equations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(giacR)
\donttest{if(!is.null(chromote::find_chrome())) {
  giac <- Giac$new()
  giac$implicitization(
    equations = "x = a*cost, y = b*sint",
    relations = "cost^2 + sint^2 = 1",
    variables = "cost, sint",
    constants = "a, b"
  )
  giac$close()
}}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Giac-close"></a>}}
\if{latex}{\out{\hypertarget{method-Giac-close}{}}}
\subsection{Method \code{close()}}{
Close a Giac session
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Giac$close()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} or \code{FALSE}, whether the session has been closed.
}
}
}
