% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_bulk_download.R
\name{gisco_bulk_download}
\alias{gisco_bulk_download}
\title{Bulk download from GISCO API}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}
}
\usage{
gisco_bulk_download(
  id_giscoR = "countries",
  year = "2016",
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE,
  resolution = "10",
  ext = "geojson",
  recursive = TRUE
)
}
\arguments{
\item{id_giscoR}{Type of dataset to be downloaded. Values supported are:
\itemize{
\item "coastallines"
\item "communes"
\item "countries"
\item "lau"
\item "nuts"
\item "urban_audit"
}}

\item{year}{Release year. See \strong{Release years available} on \code{\link{gisco_get}}.}

\item{cache_dir}{A path to a cache directory. See Details on \code{\link{gisco_get}}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the geospatial data. One of
\itemize{
\item "60": 1:60million
\item "20": 1:20million
\item "10": 1:10million
\item "03": 1:3million
\item "01": 1:1million
}}

\item{ext}{Extension of the file(s) to be downloaded. Available formats are
"geojson", "shp", "svg", "json", "gdb". See Details.}

\item{recursive}{Tries to unzip recursively the zip files (if any) included
in the initial bulk download (case of \code{ext = "shp"}.}
}
\value{
Silent function.
}
\description{
Downloads zipped data from GISCO and extract them on the \code{cache_dir} folder.
}
\details{
See the years available in \link{gisco_get}

The usual extension used across \strong{giscoR} is "geojson",
however other formats are already available on GISCO.

This function helps building a personal shape library on \code{cache_dir}
(or \code{options(gisco_cache_dir = "path/to/dir")}, if set by the user).
}
\note{
For downloading specific files use \link{gisco_get} functions.
}
\examples{
\dontrun{

# Countries 2016 - It would take some time
gisco_bulk_download(id_giscoR = "countries", resolution = "60")
}
}
\concept{political}
