% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_countries.R
\name{gisco_get_countries}
\alias{gisco_get_countries}
\title{Get GISCO world country \CRANpkg{sf} polygons, points and lines}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}
}
\usage{
gisco_get_countries(
  year = "2016",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "20",
  spatialtype = "RG",
  country = NULL,
  region = NULL
)
}
\arguments{
\item{year}{Release year of the file. One
of \code{"2001"}, \code{"2006"}, \code{"2010"}, \code{"2013"}, \code{"2016"} or \code{"2020"}.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item \code{"4258"}: ETRS89
\item \code{"4326"}: WGS84
\item \code{"3035"}: ETRS89 / ETRS-LAEA
\item \code{"3857"}: Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the geospatial data. One of
\itemize{
\item \code{"60"}: 1:60million
\item \code{"20"}: 1:20million
\item \code{"10"}: 1:10million
\item \code{"03"}: 1:3million
\item \code{"01"}: 1:1million
}}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
\item \code{"BN"}: Boundaries - \code{LINESTRING} object.
\item \code{"COASTL"}: coastlines - \code{LINESTRING} object.
\item \code{"INLAND"}: inland boundaries - \code{LINESTRING} object.
\item \code{"LB"}: Labels - \code{POINT} object.
\item \code{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
}

\strong{Note that} parameters \code{country} and \code{region} would be only applied
when \code{spatialtype} is \code{"BN"} or \code{"RG"}.}

\item{country}{Optional. A character vector of country codes. It could be
either a vector of country names, a vector of ISO3 country codes or a
vector of Eurostat country codes. Mixed types (as \code{c("Turkey","US","FRA")})
would not work. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{region}{Optional. A character vector of UN M49 region codes or
European Union membership. Possible values are \code{"Africa"}, \code{"Americas"},
\code{"Asia"}, \code{"Europe"}, \code{"Oceania"} or \code{"EU"} for countries belonging to the
European Union (as per 2021). See \strong{About world regions} and
\link{gisco_countrycode}.}
}
\value{
A \CRANpkg{sf} object specified by \code{spatialtype}.
}
\description{
Returns world country polygons, lines and points at a specified scale, as
provided by GISCO. Also, specific areas as Gibraltar or Antarctica are
presented separately. The definition of country used on GISCO
correspond roughly with territories with an official
\href{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}{ISO-3166}
code.
}
\note{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding \code{.geojson} file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.

For a complete list of files available check \link{gisco_db}.
}

\section{World Regions}{
Regions are defined as per the geographic regions defined by the
UN (see \url{https://unstats.un.org/unsd/methodology/m49/}.
Under this scheme Cyprus is assigned to Asia. You may use
\code{region = "EU"} to get the EU members (reference date: 2021).
}

\examples{

cntries <- gisco_get_countries()

library(ggplot2)
ggplot(cntries) +
  geom_sf()

# Get a region

africa <- gisco_get_countries(region = "Africa")
ggplot(africa) +
  geom_sf(fill = "#078930", col = "white") +
  theme_minimal()

}
\seealso{
\code{\link[=gisco_countrycode]{gisco_countrycode()}}, \link{gisco_countries},
\code{\link[countrycode:countrycode]{countrycode::countrycode()}}

Other political: 
\code{\link{gisco_bulk_download}()},
\code{\link{gisco_get_coastallines}()},
\code{\link{gisco_get_lau}()},
\code{\link{gisco_get_nuts}()},
\code{\link{gisco_get_postalcodes}()},
\code{\link{gisco_get_units}()},
\code{\link{gisco_get_urban_audit}()}
}
\concept{political}
