% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{gisco_countries}
\alias{gisco_countries}
\title{World countries \code{POLYGON} \code{\link[sf:sf]{sf}} object}
\format{
A \code{MULTIPOLYGON} data frame (resolution: 1:20million, EPSG:4326) object
with 257 rows and 7 variables:
\describe{
\item{id}{row ID.}
\item{CNTR_NAME}{Official country name on local language.}
\item{ISO3_CODE}{ISO 3166-1 alpha-3 code of each country, as provided by
GISCO.}
\item{CNTR_ID}{Country ID.}
\item{NAME_ENGL}{Country name in English.}
\item{FID}{FID.}
\item{geometry}{geometry field.}
}
}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/countries/geojson/}{CNTR_RG_20M_2016_4326.geojson} file.
}
\description{
A \code{\link[sf:sf]{sf}} object including all countries as provided by
GISCO (2016 version).
}
\examples{

data("gisco_countries")
head(gisco_countries)

}
\seealso{
\code{\link[=gisco_get_countries]{gisco_get_countries()}}

Other dataset: 
\code{\link{gisco_coastallines}},
\code{\link{gisco_countrycode}},
\code{\link{gisco_db}},
\code{\link{gisco_nuts}}
}
\concept{dataset}
