% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\title{Update/modify a gist}
\usage{
update(gist, description = gist$description, ...)
}
\arguments{
\item{gist}{A gist object or something coerceable to a gist}

\item{description}{(character) Brief description of gist (optional)}

\item{...}{Curl options passed on to httr::GET}
}
\description{
Update/modify a gist
}
\examples{
\dontrun{
# add new files
gists(what = "minepublic")[[3]] \%>\%
 add_files("~/zillowstuff.Rmd", "~/zoo.json") \%>\%
 update()

# update existing files
### file name has to match to current name
gists(what = "minepublic")[[3]] \%>\%
 update_files("~/zillowstuff.Rmd") \%>\%
 update()

# delete existing files
### again, file name has to match to current name
gists(what = "minepublic")[[3]] \%>\%
 delete_files("~/zillowstuff.Rmd") \%>\%
 update()

# rename existing files
# For some reason, this operation has to upload the content too
### first name is old file name with path (must match), and second is new file name (w/o path)
gists(what = "minepublic")[[3]] \%>\%
 rename_files(list("~/zillowstuff.Rmd", "zillow_pillow.Rmd")) \%>\%
 update()
### you can pass in many renames
rename_files(list("~/zillowstuff.Rmd", "zillow_pillow.Rmd"),
             list("~/myfile.Rmd", "herfile.Rmd"))
}
}

