% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.r
\docType{methods}
\name{coerce-git_tree-data.frame-method}
\alias{coerce,git_tree,data.frame-method}
\alias{coerce-git_tree-data.frame-method}
\title{Coerce entries in a git_tree to a \code{data.frame}}
\arguments{
\item{from}{The tree \code{object}}
}
\value{
\code{data.frame}
}
\description{
The entries in a tree are coerced to a \code{data.frame}
}
\details{
The \code{data.frame} have the following columns:
\describe{

\item{filemode}{
    The UNIX file attributes of a tree entry
  }

\item{type}{
    String representation of the tree entry type
  }

\item{sha}{
    The sha of a tree entry
  }

\item{name}{
    The filename of a tree entry
  }

}
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
dir.create(file.path(path, "subfolder"))
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create three files and commit
writeLines("First file",  file.path(path, "example-1.txt"))
writeLines("Second file", file.path(path, "subfolder/example-2.txt"))
writeLines("Third file",  file.path(path, "example-3.txt"))
add(repo, c("example-1.txt", "subfolder/example-2.txt", "example-3.txt"))
new_commit <- commit(repo, "Commit message")

## Coerce tree to a data.frame
df <- as(tree(new_commit), "data.frame")
df
}
}
\keyword{methods}

