% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/connect.R
\name{gitlab_connection}
\alias{gitlab_connection}
\alias{project_connection}
\title{Connect to a specific gitlab instance API}
\usage{
gitlab_connection(gitlab_url, login = NULL, email = NULL, password = NULL,
  private_token = NULL, api_location = "/api/v3/")

project_connection(gitlab_url, project, login = NULL, email = NULL,
  password = NULL, private_token = NULL, api_location = "/api/v3/")
}
\arguments{
\item{gitlab_url}{URL to the gitlab instance (e.g. \code{https://gitlab.myserver.com})}

\item{login}{name of user to login; either this or email or private token must be specified}

\item{email}{email of user to login; either this or login or private token must be specified}

\item{password}{password of user to login; if no private token but login or email is given, this must be specified}

\item{private_token}{private_token with which to identify; either this or login/email + passsword must be specified to init connection}

\item{api_location}{location of the gitlab API under the \code{gitlab_url}, usually and by default "/api/v3/"}

\item{project}{id or name of project to issue requests to}
}
\value{
A function to access a specific gitlab API as a specific user, see details
}
\description{
Creates a function that can be used to issue requests to the specified
gitlab API instance with the specified user private token and (for \code{project_connection})
only to a specified project.
}
\details{
The returned function should serve as the primary way to access the gitlab
API in the following. It can take vector/character arguments in the same way
as the function \code{\link{gitlab}} does, as well as the convenience functions
provided by this package or written by the user. If it is passed such that
function it calls it with the arguments provided in \code{...} and the gitlab
URL, api location and private_token provided when creating it via \code{gitlab_connection}.
}
\examples{
\dontrun{
my_gitlab <- gitlab_connection("http://gitlab.example.com", "123####89")
my_gitlab("projects")
my_gitlab(get_file, "test-project", "README.md", ref = "dev")
}
}

