print.starship <- function(x,digits = max(3, getOption("digits") - 3), ...)
{
# I should include the call
# Add names to the vector in starship
if(is.character(x$method.name)) {
  cat(paste(x$param,"parameterisation,",x$method.name,"estimate\n"))
} else {
cat(paste(x$param,"parameterisation\n"))}
print.default(format(x$lambda,digits=digits), print.gap = 2,quote=FALSE)
}

### Something wrong here for fkml parameterisation

summary.starship <- function(object,...)
{
cat("\nAdaptive Grid estimates:\n")
fake.lambda <- object$grid.results$lambda
names(fake.lambda) <- paste("lambda",1:length(fake.lambda),sep="")
fake.starship.object <- list(param=object$param,lambda=fake.lambda)
print.starship(fake.starship.object)
cat(paste("objective function at grid minimum:",
format(object$grid.results$response),"\n"))
cat("\nOptim (final) estimates (starting from grid estimates):\n")
print.starship(object)
cat(paste("objective function at optim minimum:",
format(object$optim.results$value),"\n"))
cat("optim.details:\nCounts: ")
print(object$optim.results$counts)
cat("Convergence: ")
print(object$optim.results$convergence)
cat("Message: ")
print(object$optim.results$message)
cat("Method: ")
print(object$optim.results$optim.method)
}

plot.starship <- function(x,data=NULL,ask=FALSE,one.page=TRUE,breaks="Sturges",histogram.title=NULL,...)
{
allpar <- par()
opar <- allpar[match(c("ask","mfrow"),names(allpar))]
if (is.null(x$data)){
	if (is.null(data)) {stop("No data to compare fit to")} 
} else {
	if (is.null(data)) {data <- x$data #using data returned by starship function
		} else { 
		warning(paste(substitute(x),"has a data element and the data argument was also given.\nUsing ",paste(substitute(data))," instead of the data element of ",substitute(x))) } }
if (ask) {par(ask=TRUE)}
if (one.page) {par(mfrow=c(2,1))}
qqgl(y=data,lambda.pars1=x$lambda,param=x$param,xlab="Fitted Theoretical Quantiles")
hist(x=data,prob=TRUE,xlab="Data",breaks=breaks,main=histogram.title,...)
plotgld(lambda1=x$lambda,param=x$param,new.plot=FALSE,...)
par(opar) # Return to previous par
}
