% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{cppBfgs}
\alias{cppBfgs}
\title{Interface to the internal C++ optimization routine "bfgs"}
\usage{
cppBfgs(x0, f_, min.x = c(-Inf), max.x = c(+Inf), prec = 1e-05,
  verbose = FALSE)
}
\arguments{
\item{x0}{the start value}

\item{f_}{the target function}

\item{min.x}{minimum bound on x (default \code{-Inf})}

\item{max.x}{maximum bound on x (default \code{+Inf})}

\item{prec}{precision (default \code{1e-5})}

\item{verbose}{be verbose? (not default)}
}
\value{
A list with the following elements:
\describe{
\item{par}{the minimum abscissa found by the algorithm}
\item{inv.hessian}{the inverse Hessian at \code{par}}
\item{evaluations}{list of the function evaluation pairs: \code{args} and
\code{vals}} 
\item{code}{the convergence code. 0 is \dQuote{OK}, -1 is \dQuote{lost
precision}, and +1 is \dQuote{change not large enough}}
}
}
\description{
Interface to the internal C++ optimization routine "bfgs"
}
\author{
Daniel Sabanes Bove \email{daniel.sabanesbove@ifspm.uzh.ch}
}
\keyword{internal}
\keyword{utilities}

