% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anova.R, R/effects.R, R/emmeans.R
\name{Anova.glmmTMB}
\alias{Anova.glmmTMB}
\alias{Effect.glmmTMB}
\alias{recover_data.glmmTMB}
\alias{emm_basis.glmmTMB}
\alias{downstream_methods}
\title{Downstream methods for glmmTMB objects}
\usage{
Anova.glmmTMB(
  mod,
  type = c("II", "III", 2, 3),
  test.statistic = c("Chisq", "F"),
  component = "cond",
  vcov. = vcov(mod)[[component]],
  singular.ok,
  ...
)

Effect.glmmTMB(focal.predictors, mod, ...)

recover_data.glmmTMB(object, ...)

emm_basis.glmmTMB(object, trms, xlev, grid, component = "cond", ...)
}
\arguments{
\item{mod}{a glmmTMB model}

\item{type}{type of test, \code{"II"}, \code{"III"}, \code{2}, or \code{3}.  Roman numerals are equivalent to the corresponding Arabic numerals. See \code{\link[car]{Anova}} for details.}

\item{test.statistic}{unused: only valid choice is "Chisq" (i.e., Wald chi-squared test)}

\item{component}{which component of the model to compute emmeans for (conditional ("cond"), zero-inflation ("zi"), or dispersion ("disp"))}

\item{vcov.}{variance-covariance matrix (usually extracted automatically)}

\item{singular.ok}{OK to do ANOVA with singular models (unused) ?}

\item{\dots}{Additional parameters that may be supported by the method.}

\item{focal.predictors}{a character vector of one or more predictors in the
model in any order.}

\item{object}{a glmmTMB model}

\item{trms}{The \code{terms} component of \code{object} (typically with the
response deleted, e.g. via \code{\link{delete.response}}}

\item{xlev}{Named list of factor levels (\emph{excluding} ones coerced to
factors in the model formula)}

\item{grid}{A \code{data.frame} (provided by \code{ref_grid}) containing the
predictor settings needed in the reference grid}
}
\description{
Methods have been written that allow \code{glmmTMB} objects to be used with
several downstream packages that enable different forms of inference.
In particular,
\itemize{
\item \code{car::Anova} constructs type-II and type-III Anova tables
for the fixed effect parameters of the conditional model (this might work with the
fixed effects of the zero-inflation or dispersion models, but has not been tested)
\item the \code{effects} package computes graphical tabular effect displays
(again, for the fixed effects of the conditional component)
\item the \code{emmeans} package computes estimated marginal means (aka least-squares means)
for the fixed effects of the conditional component
}
}
\details{
While the examples below are disabled for earlier versions of
R, they may still work; it may be necessary to refer to private
versions of methods, e.g. \code{glmmTMB:::Anova.glmmTMB(model, ...)}.
}
