% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarCorr.R
\name{format_sdvar}
\alias{format_sdvar}
\alias{format_corr}
\alias{get_sd}
\title{format columns corresponding to std. dev. and/or variance}
\usage{
format_sdvar(
  reStdDev,
  use.c = "Std.Dev.",
  formatter = format,
  digits = max(3, getOption("digits") - 2),
  ...
)

format_corr(x, maxdim = Inf, digits = 2, maxlen = 10, ...)

get_sd(x, ...)
}
\arguments{
\item{reStdDev}{a vector of standard deviations}

\item{use.c}{a character vector indicating which scales to include}

\item{formatter}{formatting function}

\item{digits}{digits for format}

\item{...}{additional parameters}

\item{x}{a square numeric matrix}

\item{maxdim}{maximum number of rows/columns to display}

\item{maxlen}{maximum number of rows to display}
}
\description{
format columns corresponding to std. dev. and/or variance
}
\examples{
invisible(gt_load("test_data/models.rda"))
format_sdvar(reStdDev = 1:3, use.c = c("Variance", "Std.Dev."))
format_sdvar(attr(VarCorr(fm1)$cond$Subject, "stddev"))
}
