% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subformula.R
\name{find_modfr_glmm}
\alias{find_modfr_glmm}
\title{Parse a formula (and possibly subformulas)}
\usage{
find_modfr_glmm(formula, subformula = NULL, data = NULL,
  family = gaussian, weights = NULL, offset = NULL)
}
\arguments{
\item{formula}{a two-sided linear formula object describing both the
    fixed-effects and random-effects part of the model, with the response
    on the left of a \code{~} operator and the terms, separated by
    \code{+} operators, on the right.  Random-effects terms are
    distinguished by vertical bars (\code{"|"}) separating expressions
    for design matrices from grouping factors.}

\item{subformula}{a subformula, describing how a substituted variable
depends on covariates, or a list of subformulas, if there is more
than one \code{Sub()} term in \code{formula}.}

\item{data}{an optional data frame, list or environment containing the
variables named in \code{formula}, and in any of the subformulas.}

\item{family}{a GLM family, see \code{\link[stats]{glm}} and
    \code{\link[stats]{family}}.}

\item{weights}{an optional vector of \sQuote{prior weights} to be used
      in the fitting process.  Should be \code{NULL} or a numeric
      vector.}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during
    fitting. This should be \code{NULL} or a numeric vector of length
    equal to the number of cases.  One or more \code{\link{offset}}
    terms can be included in the formula instead or as well, and if more
    than one is specified their sum is used.  See \code{\link{model.offset}}.}
}
\description{
Parse a formula (and possibly subformulas)
}
