% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cv.glmnet.R, R/predict.cv.relaxed.R
\name{predict.cv.glmnet}
\alias{predict.cv.glmnet}
\alias{coef.cv.glmnet}
\alias{coef.cv.relaxed}
\alias{predict.cv.relaxed}
\title{make predictions from a "cv.glmnet" object.}
\usage{
\method{predict}{cv.glmnet}(object, newx, s = c("lambda.1se", "lambda.min"), ...)

\method{predict}{cv.relaxed}(
  object,
  newx,
  s = c("lambda.1se", "lambda.min"),
  gamma = c("gamma.1se", "gamma.min"),
  ...
)
}
\arguments{
\item{object}{Fitted \code{"cv.glmnet"} or \code{"cv.relaxed"} object.}

\item{newx}{Matrix of new values for \code{x} at which predictions are to be
made. Must be a matrix; can be sparse as in \code{Matrix} package. See
documentation for \code{predict.glmnet}.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which
predictions are required. Default is the value \code{s="lambda.1se"} stored
on the CV \code{object}. Alternatively \code{s="lambda.min"} can be used. If
\code{s} is numeric, it is taken as the value(s) of \code{lambda} to be
used. (For historical reasons we use the symbol 's' rather than 'lambda' to
reference this parameter)}

\item{\dots}{Not used. Other arguments to predict.}

\item{gamma}{Value (single) of 'gamma' at which predictions are to be made}
}
\value{
The object returned depends on the \dots{} argument which is passed
on to the \code{predict} method for \code{glmnet} objects.
}
\description{
This function makes predictions from a cross-validated glmnet model, using
the stored \code{"glmnet.fit"} object, and the optimal value chosen for
\code{lambda} (and \code{gamma} for a 'relaxed' fit.
}
\details{
This function makes it easier to use the results of cross-validation to make
a prediction.
}
\examples{

x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
cv.fit = cv.glmnet(x, y)
predict(cv.fit, newx = x[1:5, ])
coef(cv.fit)
coef(cv.fit, s = "lambda.min")
predict(cv.fit, newx = x[1:5, ], s = c(0.001, 0.002))
cv.fitr = cv.glmnet(x, y, relax = TRUE)
predict(cv.fit, newx = x[1:5, ])
coef(cv.fit)
coef(cv.fit, s = "lambda.min", gamma = "gamma.min")
predict(cv.fit, newx = x[1:5, ], s = c(0.001, 0.002), gamma = "gamma.min")

}
\references{
Friedman, J., Hastie, T. and Tibshirani, R. (2008)
\emph{Regularization Paths for Generalized Linear Models via Coordinate
Descent (2010), Journal of Statistical Software, Vol. 33(1), 1-22},
\doi{10.18637/jss.v033.i01}.\cr
Simon, N., Friedman, J., Hastie, T. and Tibshirani, R. (2011)
\emph{Regularization Paths for Cox's Proportional
Hazards Model via Coordinate Descent, Journal of Statistical Software, Vol.
39(5), 1-13},
\doi{10.18637/jss.v039.i05}.\cr
Hastie, T., Tibshirani, Robert and Tibshirani, Ryan (2020) \emph{Best Subset,
Forward Stepwise or Lasso? Analysis and Recommendations Based on Extensive Comparisons,
Statist. Sc. Vol. 35(4), 579-592},
\url{https://arxiv.org/abs/1707.08692}.\cr
Glmnet webpage with four vignettes, \url{https://glmnet.stanford.edu}.
}
\seealso{
\code{glmnet}, and \code{print}, and \code{coef} methods, and
\code{cv.glmnet}.
}
\author{
Jerome Friedman, Trevor Hastie and Rob Tibshirani\cr Maintainer:
Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{models}
\keyword{regression}
